/*
 * tae5767.c
 *
 * Created: 2012/07/12 0:43:00
 *  Author: tanaka
 */ 
#include <util/delay.h>
#include "conf/config.h"
#include "tae5767.h"

void tu_send(U8 d)
{
	U8 m=0x80;
	U8 i;
	for( i = 0; i < 7; i++ ) {
		tae5767_dout(d & m);
		tae5767_clk1();
		tae5767_wc();
		tae5767_clk0();
		tae5767_wc();
		m = m >> 1;
	}		
}

U8 tu_read()
{
	U8 d=0;
	U8 i;
	for( i = 0; i < 7; i++ ) {
		d = d << 1;
		tae5767_clk1();
		tae5767_wc2();
		if( tae5767_din() ) d |= 1;
		tae5767_wc2();
		tae5767_clk0();
		tae5767_wc();
	}
	return d;
}

void tu_tune(U8 f0, U8 f1)
{
	tae5767_rw1();
	tae5767_wc();
	tu_send(f0);	// byte 1
	tu_send(f1);	// byte 2
	tu_send(0x10);	// byte 3 B'00010000' bit 4 hight side injection
	tu_send(0x42);	// byte 4 B'00110010'
	tu_send(0x80);	// byte 5 B'10000000'
	tae5767_rw0();
}

void tu_status(U8 *d)
{
	tae5767_rw0();
	tae5767_wc();
	*d = tu_read();
	*d = tu_read();
	*d = tu_read();
	*d = tu_read();
	*d = tu_read();
}
