#pragma once

typedef struct Symbol {
	char 	*name;
	short 	type;
	union {
		double val;
		double (*ptr)(double);
	} u;
	struct Symbol	*next;
} Symbol;

extern Symbol *install(char *s, int t, double d);
extern Symbol *lookup(char *s);

/* code.c */
typedef union Datum {
	double	val;
	Symbol	*sym;
} Datum;


typedef Datum (*Inst)();
#define STOP	(Inst)0

extern Inst prog[];

extern Datum pop();
extern Datum eval(), add(), sub(), mul(), divid(), negate(), power();
extern Datum assign(), bltin(), varpush(), constpush(), print();

extern void initcode();
extern Inst *code(Inst);
extern void execute(Inst *p);

/* main.c */
extern int yylex();
extern int yyerror(char *s);
extern int execerror(char *s, char *t);

