%{
#include <stdio.h>
#include "y.tab.h"
#include "hoc.h"
%}
%union {
	double val;
	int index;
}
%token 	<val> 	NUMBER
%token 	<index> VAR
%type 	<val> 	expr
%right 	'='
%left 	'+' '-' /* left associative, name precedence */
%left 	'*' '/' /* left assoc., higher procedence */
%left  UNARYMINUS
%%
list:	/*nothing*/
		| list '\n'
		| list expr '\n'	{ printf("\t%.8g\n", $2); }
		;

expr:	NUMBER				{ $$ = $1; }
		| VAR				{ $$ = mem[$1]; }
		| VAR '=' expr		{ mem[$1] = $3; }
		| expr '+' expr		{ $$ = $1 + $3; }
		| expr '-' expr		{ $$ = $1 - $3; }	
		| expr '*' expr		{ $$ = $1 * $3; }	
		| expr '/' expr		{ 
			if ($3 == 0.0)
				execerror("division by zero", "");
			$$ = $1 / $3; }	
		| '(' expr ')'		{ $$ = $2; }
		| '-' expr %prec UNARYMINUS { $$ = -$2; }
		;
%%
