#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>
#include "y.tab.h"
#include "hoc.h"

extern int yyparse();

double mem[26];

static char *progname; 	/* for error message */
static int lineno = 1;
static jmp_buf begin;

int main(int arc, char **argv) {
	progname = argv[0];
	setjmp(begin);
	yyparse();
}

int warning(char *s, char* t) {
	fprintf(stderr, "%s: %s", progname, s);
	if(t)
		fprintf(stderr, " %s", t);
	fprintf(stderr, " near line %d\n", lineno);
	return 0;
}

int execerror(char *s, char *t) {
	warning(s, t);
	longjmp(begin, 0);
	return 0;
}


int yyerror(char *s) {
	warning(s, (char*)0);
	return 0;
}

int yylex() {
	int c;

	while ((c=getchar()) == ' ' || c == '\t')
		;

	if (c==EOF)
		return 0;

	if (c=='.' || isdigit(c)) { /*NUMBER*/
		ungetc(c, stdin);
		scanf("%lf", &yylval.val);
		return NUMBER;
	}

	if (islower(c)) {
		yylval.index = c - 'a';
		return VAR;
	}

	if (c=='\n')
		lineno++;

	return c;
}
