#include "stdafx.h"
#include <stdexcept>
#include <iostream>
#include "Container.h"

char szErrorMessage1[] = "too many initializers";
char szErrorMessage2[] = "invalid row or column index";
char szErrorMessage3[] = "matrix size unmatch";


/* sNX */

template class CMatrix<int>;
template class CMatrix<double>;
template CMatrix<int> operator*(int a, const CMatrix<int>& m);
template CMatrix<double> operator*(double a, const CMatrix<double>& m);

template <typename Type> CMatrix<Type>::CMatrix()
	: m_rows(0), m_cols(0), m_element(nullptr)
{
}

// RXgN^
template <typename Type> CMatrix<Type>::CMatrix(int arg1, int arg2)
	: m_rows(arg1), m_cols(arg2), m_element(nullptr)
{
	m_element = new Type[m_rows*m_cols];
	Initialize();
}
template <typename Type> CMatrix<Type>::CMatrix(int arg1, int arg2, std::initializer_list<Type> init)
	: m_rows(arg1), m_cols(arg2), m_element(nullptr)
{
	m_element = new Type[m_rows*m_cols];
	if (init.size() > (size_t)(m_rows*m_cols))
	{
		throw std::out_of_range(szErrorMessage1);
	}
	Initialize();
	Type* p = m_element;
	std::initializer_list<Type>::iterator ite;
	for (ite = init.begin(); ite < init.end(); ++ite, ++p)	*p = *ite;
}
template <typename Type> CMatrix<Type>::CMatrix(std::initializer_list< std::initializer_list<Type> > init)
	: m_rows(0), m_cols(0), m_element(nullptr)
{
	m_rows = (int)init.size();
	std::initializer_list< std::initializer_list<Type> >::iterator ite;
	for (ite = init.begin(); ite < init.end(); ++ite)
	{
		if ((int)(ite->size()) > m_cols)
		{
			m_cols = (int)(ite->size());
		}
	}
	m_element = new Type[m_rows*m_cols];
	Initialize();
	Type* p = m_element;
	for (ite = init.begin(); ite < init.end(); ++ite, p+=m_cols)
	{
		std::initializer_list<Type>::iterator ite2;
		int n = 0;
		for (ite2 = ite->begin(); ite2 < ite->end(); ++ite2, ++n)
		{
			p[n] = *ite2;
		}
	}
}

// Rs[RXgN^
template <typename Type> CMatrix<Type>::CMatrix(const CMatrix<Type>& src)
	: m_rows(src.m_rows), m_cols(src.m_cols), m_element(nullptr)
{
	m_element = new Type[m_rows*m_cols];
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		m_element[i] = src.m_element[i];
	}
}

// fXgN^
template <typename Type> CMatrix<Type>::~CMatrix()
{
	delete[] m_element;
}

// 
template <typename Type> void CMatrix<Type>::Initialize(void)
{
	for (int e = 0; e < m_rows*m_cols; e++)
	{
		m_element[e] = (Type)0;
	}
}

// vpeB
template <typename Type> int CMatrix<Type>::Rows(void) const
{
	return m_rows;
}
template <typename Type> int CMatrix<Type>::Cols(void) const
{
	return m_cols;
}

// vf̎o
template <typename Type> Type CMatrix<Type>::Get(int row, int col) const
{
	int n = row * m_cols + col;
	if ((n < 0) || (n >= m_rows * m_cols))
	{
		throw std::out_of_range(szErrorMessage2);
	}
	return m_element[n];
}

// vf̐ݒ
template <typename Type> void CMatrix<Type>::Set(int row, int col, Type data)
{
	int n = row * m_cols + col;
	if ((n < 0) || (n >= m_rows * m_cols))
	{
		throw std::out_of_range(szErrorMessage2);
	}
	m_element[n] = data;
}

// Zq
template <typename Type> CMatrix<Type> CMatrix<Type>::operator=(const CMatrix& m)
{
	if ((m_rows != m.m_rows) || (m_cols != m.m_cols))
	{
		throw std::out_of_range(szErrorMessage2);
	}
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		m_element[i] = m.m_element[i];
	}
	return *this;
}

// Zq
template <typename Type> bool CMatrix<Type>::operator==(const CMatrix<Type>& m) const
{
	if ((m_rows != m.m_rows) || (m_cols != m.m_cols))
	{
		return false;
	}
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		if (m_element[i] != m.m_element[i])
		{
			return false;
		}
	}
	return true;
}

// XJ{
template <typename Type> CMatrix<Type> CMatrix<Type>::operator*(Type a) const
{
	CMatrix<Type> tmp(*this);
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		tmp.m_element[i] *= a;
	}
	return tmp;
}
template <typename Type2> CMatrix<Type2> operator*(Type2 a, const CMatrix<Type2>& m)
{
	CMatrix<Type2> tmp(m);
	for (int i = 0; i < m.m_rows*m.m_cols; i++)
	{
		tmp.m_element[i] *= a;
	}
	return tmp;
}

// 
template <typename Type> CMatrix<Type> CMatrix<Type>::operator+() const
{
	return *this;
}

// 
template <typename Type> CMatrix<Type> CMatrix<Type>::operator-() const
{
	CMatrix<Type> tmp(m_rows, m_cols);
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		tmp.m_element[i] = -m_element[i];
	}
	return tmp;
}

// a
template <typename Type> CMatrix<Type> CMatrix<Type>::operator+(const CMatrix<Type>& m) const
{
	if ((m_rows != m.m_rows) || (m_cols != m.m_cols))
	{
		throw std::out_of_range(szErrorMessage2);
	}
	CMatrix<Type> tmp(*this);
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		tmp.m_element[i] = tmp.m_element[i] + m.m_element[i];
	}
	return tmp;
}
template <typename Type> CMatrix<Type> CMatrix<Type>::operator+=(const CMatrix<Type>& m)
{
	(*this) = (*this) + m;
	return (*this);
}

// 
template <typename Type> CMatrix<Type> CMatrix<Type>::operator-(const CMatrix<Type>& m) const
{
	if ((m_rows != m.m_rows) || (m_cols != m.m_cols))
	{
		throw std::out_of_range(szErrorMessage2);
	}
	CMatrix<Type> tmp(*this);
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		tmp.m_element[i] = tmp.m_element[i] - m.m_element[i];
	}
	return tmp;
}
template <typename Type> CMatrix<Type> CMatrix<Type>::operator-=(const CMatrix<Type>& m)
{
	(*this) = (*this) - m;
	return (*this);
}

// Os
template <typename Type> CMatrix<Type> CMatrix<Type>::Zero(void) const
{
	CMatrix<Type> tmp(m_rows, m_cols);
	for (int i = 0; i < m_rows*m_cols; i++)
	{
		tmp.m_element[i] = (Type)0;
	}
	return tmp;
}

// 
template <typename Type> CMatrix<Type> CMatrix<Type>::operator*(const CMatrix<Type>& m) const
{
	if (m_cols != m.m_rows)
	{
		throw std::out_of_range(szErrorMessage3);
	}
	CMatrix<Type> tmp(*this);
	for (int c = 0; c < m_cols; c++)
	{
		for (int r = 0; r < m_rows; r++)
		{
			Type s = (Type)0;
			for (int n = 0; n < m.m_rows; n++)
			{
				//s = s + m_element[r*m_cols + n] * m.m_element[n*m.m_cols + c];
				s = s + Get(r, n) * m.Get(n, c);
			}
			tmp.Set(r, c, s);
		}
	}
	return tmp;
}
template <typename Type> CMatrix<Type> CMatrix<Type>::operator*=(const CMatrix<Type>& m)
{
	(*this) = (*this) * m;
	return (*this);
}

