#include "stdafx.h"
#include "LogManager.h"
#include "Container.h"
#include "DIBData.h"


CDIBData::CDIBData()
{
	ZeroMemory(&m_info, sizeof(m_info));
	m_pbits = NULL;
	m_numbits = 0;
	m_mop = MOP_NONE;
	m_logic = 0;
	m_transcolor = 0;
}


CDIBData::CDIBData(int width, int height)
{
	ZeroMemory(&m_info, sizeof(m_info));
	m_pbits = NULL;
	m_numbits = 0;
	m_mop = MOP_NONE;
	m_logic = 0;
	Create(width, height);
	m_transcolor = 0;
}


CDIBData::CDIBData(const CDIBData& src)
{
	memcpy_s(&m_info, sizeof(m_info), &src.m_info, sizeof(src.m_info));
	m_numbits = src.m_numbits;
	m_pbits = new DWORD[m_numbits];
	memcpy_s(m_pbits, m_numbits * sizeof(DWORD), src.m_pbits, src.m_numbits * sizeof(DWORD));
	m_mop = src.m_mop;
	m_logic = src.m_logic;
	m_transcolor = src.m_transcolor;
}


CDIBData::~CDIBData()
{
	delete[] m_pbits;
}


// sNZf[^i[mہBITMAPINFOwb_쐬
void CDIBData::Create(int width, int height)
{
	if (abs(width)*abs(height) > m_numbits)
	{
		delete[] m_pbits;
		m_numbits = abs(width) * abs(height);
		m_pbits = new DWORD[m_numbits];
		ZeroMemory(m_pbits, m_numbits*sizeof(DWORD));
	}
	m_info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_info.bmiHeader.biWidth = width;
	m_info.bmiHeader.biHeight = height;
	m_info.bmiHeader.biPlanes = 1;
	m_info.bmiHeader.biBitCount = 32;
	m_info.bmiHeader.biCompression = BI_RGB;
	m_info.bmiHeader.biSizeImage = width * height * sizeof(DWORD);
	m_info.bmiHeader.biXPelsPerMeter = 0;
	m_info.bmiHeader.biYPelsPerMeter = 0;
	m_info.bmiHeader.biClrUsed = 0;
	m_info.bmiHeader.biClrImportant = 0;
}


// sNZŜw̒lɐݒ肷
void CDIBData::Clear(DWORD col)
{
	for (int n = 0; n < m_numbits; ++n)
	{
		m_pbits[n] = col;
	}
}


// rbg}bṽsNZf[^擾
int CDIBData::GetDIBits(HDC hdc, HBITMAP hbmp)
{
	return ::GetDIBits(hdc, hbmp, 0, m_info.bmiHeader.biHeight, m_pbits, &m_info, DIB_RGB_COLORS);
}


// sNZf[^rbg}bvɔf
int CDIBData::SetDIBits(HDC hdc, HBITMAP hbmp)
{
	return ::SetDIBits(hdc, hbmp, 0, m_info.bmiHeader.biHeight, m_pbits, &m_info, DIB_RGB_COLORS);
}


// wʒũsNZf[^ݒ肷
DWORD CDIBData::SetPixcel(int x, int y, DWORD col)
{
	if (m_pbits == NULL)
	{
		return -1;
	}
	int d = (m_info.bmiHeader.biHeight - y - 1) * m_info.bmiHeader.biWidth + x;
	if ((d < 0) || (d >= m_info.bmiHeader.biWidth * m_info.bmiHeader.biHeight))
	{
		return -1;
	}

	return *(m_pbits + d) = col;
}


// wʒũsNZf[^擾
DWORD CDIBData::GetPixcel(int x, int y)
{
	if (m_pbits == NULL)
	{
		return -1;
	}
	int d = (m_info.bmiHeader.biHeight - y - 1) * m_info.bmiHeader.biWidth + x;
	if ((d < 0) || (d >= m_info.bmiHeader.biWidth * m_info.bmiHeader.biHeight))
	{
		return -1;
	}

	return *(m_pbits + d);
}


// `̈Ɏw̃sNZf[^ݒ肷
void CDIBData::FillRect(int x1, int y1, int x2, int y2, DWORD col)
{
	int left, top, right, bottom;
	if (x1 <= x2)
	{
		left = x1;
		right = x2;
	}
	else
	{
		left = x2;
		right = x1;
	}
	if (y1 <= y2)
	{
		top = y1;
		bottom = y2;
	}
	else
	{
		top = y2;
		bottom = y1;
	}
	if ((left >= m_info.bmiHeader.biWidth) || (right < 0))
	{
		return;
	}
	if (left < 0)	left = 0;
	if (right > m_info.bmiHeader.biWidth)	right = m_info.bmiHeader.biWidth;
	if ((top >= m_info.bmiHeader.biHeight) || (bottom < 0))
	{
		return;
	}
	if (top < 0)	top = 0;
	if (bottom > m_info.bmiHeader.biHeight)	bottom = m_info.bmiHeader.biHeight;
	for (int y = top; y < bottom; ++y)
	{
		LPDWORD pd = m_pbits + (m_info.bmiHeader.biHeight - y - 1) * m_info.bmiHeader.biWidth;
		for (int x = left; x < right; ++x)
		{
			*(pd + x) = col;
		}
	}
}


// _`
void CDIBData::DrawDot(int x, int y, int size, DWORD col)
{
	if (m_pbits == NULL)
	{
		return;
	}
	if ((x < 0) || (x >= m_info.bmiHeader.biWidth) || (y < 0) || (y >= m_info.bmiHeader.biHeight))
	{
		return;
	}
	for (int r = 0; r < size; ++r)
	{
		int dy = y - size / 2 + r;
		if ((dy < 0) || (dy >= m_info.bmiHeader.biHeight))	continue;
		for (int c = 0; c < size; ++c)
		{
			int dx = x - size / 2 + c;
			if ((dx < 0) || (dx >= m_info.bmiHeader.biWidth))	continue;
			if ((c - size / 2) * (c - size / 2) + (r - size / 2) * (r - size / 2) <= size * size / 4)
				SetPixcel(dx, dy, col);
		}
	}
}


// `
void CDIBData::DrawLine(int x1, int y1, int x2, int y2, int size, DWORD col)
{
	if (m_pbits == NULL)
	{
		return;
	}
	if (size <= 0)	return;
	// NbsO
	CIPoint<int> c1 = { 0, 0 };
	CIPoint<int> c2 = { m_info.bmiHeader.biWidth - 1, m_info.bmiHeader.biHeight - 1 };
	CIPoint<int> q1 = { x1, y1 };
	CIPoint<int> q2 = { x2, y2 };
	if (!cripping<int>(c1, c2, q1, q2))
	{
		if ((q1.x < c1.x) || (q1.x > c2.x) || (q1.y < c1.y) || (q1.y > c2.y) ||
			(q2.x < c1.x) || (q2.x > c2.x) || (q2.y < c1.y) || (q2.y > c2.y))
		{
			return;
		}
	}
	// `
	bool xlong;
	//		n_EI_ݒiwEx̒ق xlƂj
	CIPoint<int> l1, l2;
	if (abs(q2.x - q1.x) > abs(q2.y - q1.y)) {
		xlong = true;
		if (q1.x <= q2.x) {
			l1 = { q1.x, q1.y };
			l2 = { q2.x, q2.y };
		}
		else {
			l1 = { q2.x, q2.y };
			l2 = { q1.x, q1.y };
		}
	}
	else {
		xlong = false;
		if (q1.y <= q2.y) {
			l1 = { q1.y, q1.x };
			l2 = { q2.y, q2.x };
		}
		else {
			l1 = { q2.y, q2.x };
			l2 = { q1.y, q1.x };
		}
	}
	if (l1.x == l2.x)	return;
	//		`̈̒_W߂
	double h = (l2.x - l1.x) * size / 2.0 / sqrt((l2.x - l1.x) * (l2.x - l1.x) + (l2.y - l1.y) * (l2.y - l1.y));
	double w = - (l2.y - l1.y) * size / 2.0 / sqrt((l2.x - l1.x) * (l2.x - l1.x) + (l2.y - l1.y) * (l2.y - l1.y));
	CIPoint<double> k1 = { l1.x + w, l1.y + h };
	CIPoint<double> k2 = { l2.x + w, l2.y + h };
	CIPoint<double> m1 = { l1.x - w, l1.y - h };
	CIPoint<double> m2 = { l2.x - w, l2.y - h };
	CIPoint<double> r1 = { min(k1.x, m1.x), min(m1.y, m2.y) };
	CIPoint<double> r2 = { max(k2.x, m2.x), max(k1.y, k2.y) };

	//		PsNZPʂ̒Zh
	for (double dx = floor(r1.x); dx < r2.x; dx += 1.0)
	{
		CIPoint<double> dq1, dq2;
		if (cross_point<double>(k1, k2, { dx, r1.y }, { dx, r2.y }, dq1))
		{
			if (cross_point<double>(k1, m1, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else if (cross_point<double>(k2, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else if (cross_point<double>(m1, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else
			{
				continue;
			}
		}
		else
		{
			if (cross_point<double>(k1, m1, { dx, r1.y }, { dx, r2.y }, dq1))
			{
			}
			else if (cross_point<double>(k2, m2, { dx, r1.y }, { dx, r2.y }, dq1))
			{
			}
			else
			{
				continue;
			}
			if (!cross_point<double>(m1, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
				continue;
			}
		}
		int ix = (int)dx;
		int ny = (int)(dq1.y - dq2.y);
		if (ny > size)	ny = size;
		for (int i = 0, iy = (int)dq2.y; i < ny; ++i, ++iy)
		{
			if (xlong)
			{
				SetPixcel(ix, iy, col);
			}
			else
			{
				SetPixcel(iy, ix, col);
			}
		}
	}
}


// _`(smoothing)
void CDIBData::DrawDotS(double x, double y, double size, DWORD col)
{
	if (m_pbits == NULL)
	{
		return;
	}
	if ((x < 0.0) || (x >= m_info.bmiHeader.biWidth) || (y < 0.0) || (y >= m_info.bmiHeader.biHeight) || (size < 1.0))
	{
		return;
	}
	int ny = (int)floor(y - size / 2);
	if (ny < 0)	ny = 0;
	for (; (ny <= (int)ceil(y + size / 2)) && (ny <= m_info.bmiHeader.biHeight); ++ny)
	{
		int nx = (int)floor(x - size / 2);
		if (nx < 0)	nx = 0;
		for (; (nx <= (int)ceil(x + size / 2)) && (nx <= m_info.bmiHeader.biWidth); ++nx)
		{
			double d = sqrt((ny - y) * (ny - y) + (nx - x) * (nx - x)) - size / 2;
			if (d >= 1.0)
			{
				continue;
			}
			if (d <= 0.0)
			{
				d = 1.0;
				SetPixcel(nx, ny, col);
			}
			else
			{
				DWORD cs = GetPixcel(nx, ny);
				DWORD cw = _MColor(col, cs, 1 - d);
				SetPixcel(nx, ny, cw);
			}
		}
	}
}


// `(smoothing)
void CDIBData::DrawLineS(double x1, double y1, double x2, double y2, DWORD col)
{
	if (m_pbits == NULL)
	{
		return;
	}
	// NbsO
	CIPoint<double> c1 = { 0.0, 0.0 };
	CIPoint<double> c2 = { (double)(m_info.bmiHeader.biWidth - 1), (double)(m_info.bmiHeader.biHeight - 1) };
	CIPoint<double> q1 = { x1, y1 };
	CIPoint<double> q2 = { x2, y2 };
	if (!cripping<double>(c1, c2, q1, q2))
	{
		if ((q1.x < c1.x) || (q1.x > c2.x) || (q1.y < c1.y) || (q1.y > c2.y) ||
			(q2.x < c1.x) || (q2.x > c2.x) || (q2.y < c1.y) || (q2.y > c2.y))
		{
			return;
		}
	}
	// [hbg`
	DrawDotS(q1.x, q1.y, 2.0, col);
	DrawDotS(q2.x, q2.y, 2.0, col);
	// `
	bool xlong;
	CIPoint<double> l1, l2;
	if (abs(q2.x - q1.x) > abs(q2.y - q1.y)){
		xlong = true;
		if (q1.x <= q2.x){
			l1 = { q1.x, q1.y };
			l2 = { q2.x, q2.y };
		}
		else {
			l1 = { q2.x, q2.y };
			l2 = { q1.x, q1.y };
		}
	}
	else {
		xlong = false;
		if (q1.y <= q2.y){
			l1 = { q1.y, q1.x };
			l2 = { q2.y, q2.x };
		}
		else {
			l1 = { q2.y, q2.x };
			l2 = { q1.y, q1.x };
		}
	}
	if (l1.x == l2.x)	return;
	double a = (l2.y - l1.y) / (l2.x - l1.x);
	double z = /*sqrt(1.0 + a * a)*/ 1.0;
	for (double d = floor(l1.x) + 1.0; d < floor(l2.x); d += 1.0)
	{
		double e = a * (d - l1.x) + l1.y;
		double f = e - floor(e);
		DWORD c1 = _AColor(col, f * z);
		DWORD c2 = _AColor(col, (1.0 - f) * z);
		DWORD cx;
		if (xlong)
		{
			cx = GetPixcel((int)d, (int)floor(e));
			cx = _RGB(max(_GetRValue(cx), _GetRValue(col)), max(_GetGValue(cx), _GetGValue(col)), max(_GetBValue(cx), _GetBValue(col)));
			SetPixcel((int)d, (int)floor(e), cx);
			cx = GetPixcel((int)d, (int)floor(e) + 1);
			cx = _RGB(max(_GetRValue(cx), _GetRValue(c1)), max(_GetGValue(cx), _GetGValue(c1)), max(_GetBValue(cx), _GetBValue(c1)));
			SetPixcel((int)d, (int)(floor(e) + 1), cx);
			cx = GetPixcel((int)d, (int)floor(e) - 1);
			cx = _RGB(max(_GetRValue(cx), _GetRValue(c2)), max(_GetGValue(cx), _GetGValue(c2)), max(_GetBValue(cx), _GetBValue(c2)));
			SetPixcel((int)d, (int)(floor(e) - 1), cx);
		}
		else
		{
			cx = GetPixcel((int)floor(e), (int)d);
			cx = _RGB(max(_GetRValue(cx), _GetRValue(col)), max(_GetGValue(cx), _GetGValue(col)), max(_GetBValue(cx), _GetBValue(col)));
			SetPixcel((int)floor(e), (int)d, cx);
			cx = GetPixcel((int)floor(e + 1), (int)d);
			cx = _RGB(max(_GetRValue(cx), _GetRValue(c1)), max(_GetGValue(cx), _GetGValue(c1)), max(_GetBValue(cx), _GetBValue(c1)));
			SetPixcel((int)(floor(e) + 1), (int)d, cx);
			cx = GetPixcel((int)floor(e - 1), (int)d);
			cx = _RGB(max(_GetRValue(cx), _GetRValue(c2)), max(_GetGValue(cx), _GetGValue(c2)), max(_GetBValue(cx), _GetBValue(c2)));
			SetPixcel((int)(floor(e) - 1), (int)d, cx);
		}
	}
}


// `(smoothing)
void CDIBData::DrawLineS(double x1, double y1, double x2, double y2, double size, DWORD col)
{
	if (m_pbits == NULL)
	{
		return;
	}
	if (size <= 0.0)	return;
	// NbsO
	CIPoint<double> c1 = { 0.0, 0.0 };
	CIPoint<double> c2 = { (double)(m_info.bmiHeader.biWidth - 1), (double)(m_info.bmiHeader.biHeight - 1) };
	CIPoint<double> q1 = { x1, y1 };
	CIPoint<double> q2 = { x2, y2 };
	if (!cripping<double>(c1, c2, q1, q2))
	{
		if ((q1.x < c1.x) || (q1.x > c2.x) || (q1.y < c1.y) || (q1.y > c2.y) ||
			(q2.x < c1.x) || (q2.x > c2.x) || (q2.y < c1.y) || (q2.y > c2.y))
		{
			return;
		}
	}
	// [hbg`
	//DrawDotS(q1.x, q1.y, size / 2.0, col);
	//DrawDotS(q2.x, q2.y, size / 2.0, col);
	// `
	bool xlong;
	//		n_EI_ݒiwEx̒ق xlƂj
	CIPoint<double> l1, l2;
	if (abs(q2.x - q1.x) > abs(q2.y - q1.y)) {
		xlong = true;
		if (q1.x <= q2.x) {
			l1 = { q1.x, q1.y };
			l2 = { q2.x, q2.y };
		}
		else {
			l1 = { q2.x, q2.y };
			l2 = { q1.x, q1.y };
		}
	}
	else {
		xlong = false;
		if (q1.y <= q2.y) {
			l1 = { q1.y, q1.x };
			l2 = { q2.y, q2.x };
		}
		else {
			l1 = { q2.y, q2.x };
			l2 = { q1.y, q1.x };
		}
	}
	if (l1.x == l2.x)	return;
	//		`̈̒_W߂
	double X = l2.x - l1.x;
	double Y = l2.y - l1.y;
	double L = sqrt(X * X + Y * Y);
	double h = X * size / 2.0 / L;
	double w = -Y * size / 2.0 / L;
	CIPoint<double> k1 = { l1.x + w, l1.y + h };
	CIPoint<double> k2 = { l2.x + w, l2.y + h };
	CIPoint<double> m1 = { l1.x - w, l1.y - h };
	CIPoint<double> m2 = { l2.x - w, l2.y - h };
	CIPoint<double> r1 = { min(k1.x, m1.x), min(m1.y, m2.y) };
	CIPoint<double> r2 = { max(k2.x, m2.x), max(k1.y, k2.y) };

	//		PsNZPʂ̒Zh
	for (double dx = floor(r1.x); dx < r2.x; dx += 1.0)
	{
		//		Zdq1-dq2W߂
		CIPoint<double> dq1, dq2;
		if (cross_point<double>(k1, k2, { dx, r1.y }, { dx, r2.y }, dq1))
		{
			if (cross_point<double>(k1, m1, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else if (cross_point<double>(k2, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else if (cross_point<double>(m1, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
			}
			else
			{
				continue;
			}
		}
		else
		{
			if (cross_point<double>(k1, m1, { dx, r1.y }, { dx, r2.y }, dq1))
			{
			}
			else if (cross_point<double>(k2, m2, { dx, r1.y }, { dx, r2.y }, dq1))
			{
			}
			else
			{
				continue;
			}
			if (!cross_point<double>(m1, m2, { dx, r1.y }, { dx, r2.y }, dq2))
			{
				continue;
			}
		}
		//		Z`iPsNZj
		double ax = 1.0;
		if (dx < r1.x)
		{
			ax -= r1.x - dx;
		}
		if (dx > r2.x - 1.0)
		{
			ax -= dx + 1.0 - r2.x;
		}
		for (double dy = floor(dq2.y); dy < dq1.y; dy += 1.0)
		{
			double ay = 1.0;
			if (dy < dq2.y)
			{
				ay -= dq2.y - dy;
			}
			if (dy > dq1.y - 1.0)
			{
				ay -= dy + 1.0 - dq1.y;
			}
			DWORD cs, cw;
			int ix = (int)dx;
			int iy = (int)dy;
			if (xlong)
			{
				cs = GetPixcel(ix, iy);
				cw = _MColor(col, cs, ax * ay);
				SetPixcel(ix, iy, cw);
			}
			else
			{
				cs = GetPixcel(iy, ix);
				cw = _MColor(col, cs, ax * ay);
				SetPixcel(iy, ix, cw);
			}
		}
	}
}


// DIBf[^Nbv{[hɃRs[
int CDIBData::Copy(HWND hwnd)
{
	HGLOBAL hg;
	hg = ::GlobalAlloc(GHND | GMEM_DDESHARE, sizeof(BITMAPINFO) + m_numbits * sizeof(DWORD));
	if (hg == NULL)
	{
		LOG_WIN_ERROR(_T("GlobalAlloc"));
		return 0;
	}
	void* pgm = ::GlobalLock(hg);
	if (pgm == NULL)
	{
		LOG_WIN_ERROR(_T("GlobalLock"));
		return 0;
	}
	memcpy((LPBYTE)pgm, &m_info, sizeof(BITMAPINFOHEADER));
	memcpy((LPBYTE)pgm + sizeof(BITMAPINFOHEADER), m_pbits, m_numbits * sizeof(DWORD));
	::GlobalUnlock(pgm);

	if (::OpenClipboard(hwnd) == 0)
	{
		LOG_WIN_ERROR(_T("OpenClipboard"));
		return 0;
	}
	if (::EmptyClipboard() == 0)
	{
		LOG_WIN_ERROR(_T("EmptyClipboard"));
		return 0;
	}
	if (::SetClipboardData(CF_DIB, hg) == 0)
	{
		LOG_WIN_ERROR(_T("SetClipboardData"));
		return 0;
	}
	if (::CloseClipboard() == 0)
	{
		LOG_WIN_ERROR(_T("CloseClipboard"));
		return 0;
	}

	return 1;
}


// DIBf[^
int CDIBData::Merge(const CDIBData& src)
{
	bool trans = (src.m_mop & MOP_TRANS) ? true : false;
	int width = min(m_info.bmiHeader.biWidth, src.m_info.bmiHeader.biWidth);
	int height = min(m_info.bmiHeader.biHeight, src.m_info.bmiHeader.biHeight);
	for (int y = 0; y < height; ++y)
	{
		LPDWORD pdst = m_pbits + m_info.bmiHeader.biWidth * y;
		LPDWORD psrc = src.m_pbits + m_info.bmiHeader.biWidth * y;
		for (int x = 0; x < width; ++x, ++pdst, ++psrc)
		{
			if (!trans || (*psrc != src.m_transcolor))
			{
				*pdst = *psrc;
			}
		}
	}

	return 0;
}


// W(0.0`1.0)RGBl߂
DWORD CDIBData::_AColor(DWORD rgb, double a)
{
	for (int nc = 0; nc < 3; ++nc)
	{
		DWORD g = (DWORD)(((rgb >> (nc * 8)) & 0xff) * a);
		if (g > 255)	g = 255;
		rgb = rgb & ~(0xff << (nc * 8)) | (g << (nc * 8));
	}
	return rgb;
}


// W(0.0`1.0)ɂQF̍
DWORD CDIBData::_MColor(DWORD rgb1, DWORD rgb2, double a)
{
	DWORD rgb = 0;
	for (int nc = 0; nc < 3; ++nc)
	{
		DWORD g = (DWORD)(
			((rgb1 >> (nc * 8)) & 0xff) * a + 
			((rgb2 >> (nc * 8)) & 0xff) * (1.0 - a)
			);
		if (g > 255)	g = 255;
		rgb = rgb & ~(0xff << (nc * 8)) | (g << (nc * 8));
	}
	return rgb;
}
