//******************************************************************************
//
// MIDITrail / DXMesh
//
// bV`NX
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DXMesh.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DXMesh::DXMesh(void)
{
	m_pMesh = NULL;
	m_NumMaterials = 0;
	m_pMeshMaterials = NULL;
	m_pMeshTextures = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
DXMesh::~DXMesh(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
void DXMesh::Release()
{
	unsigned long i = 0;

	for (i = 0; i < m_NumMaterials; i++) {
		if (m_pMeshTextures[i] != NULL) {
			(m_pMeshTextures[i])->Release();
			m_pMeshTextures[i] = NULL;
		}
	}
	delete [] m_pMeshMaterials;
	delete [] m_pMeshTextures;
	m_pMeshMaterials = NULL;
	m_pMeshTextures = NULL;
	m_NumMaterials = 0;

	if (m_pMesh != NULL) {
		m_pMesh->Release();
		m_pMesh = NULL;
	}

	return;
}

//******************************************************************************
// 
//******************************************************************************
int DXMesh::Initialize(
		LPDIRECT3DDEVICE9 pD3DDevice,
		TCHAR* pMeshFilePath
	)
{
	int result = 0;

	//t@CwȂ牽Ȃ
	if (_tcslen(pMeshFilePath) == 0) goto EXIT;

	//bVt@Cǂݍ
	result = _LoadMeshFile(pD3DDevice, pMeshFilePath);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// bVt@Cǂݍ
//******************************************************************************
int DXMesh::_LoadMeshFile(
		LPDIRECT3DDEVICE9 pD3DDevice,
		TCHAR* pMeshFilePath
	)
{
	int result = 0;
	unsigned long i = 0;
	HRESULT hresult = D3D_OK;
	LPD3DXBUFFER pMaterialBuffer = NULL;
	TCHAR textureFilePath[_MAX_PATH];
	D3DXMATERIAL* pMaterials = NULL;

	//bVt@Cǂݍ
	hresult = D3DXLoadMeshFromX(
					pMeshFilePath,		//bVt@CpX
					D3DXMESH_MANAGED,	//bV쐬IvV
					pD3DDevice,			//foCXIuWFNg
					NULL,				//אڐf[^
					&pMaterialBuffer,	//}eA
					NULL,				//GtFNgCX^X
					&m_NumMaterials,	//}eA
					&m_pMesh			//bV
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//}eA擪ʒu
	pMaterials = (D3DXMATERIAL*)pMaterialBuffer->GetBufferPointer();

	//zobt@
	try {
		m_pMeshMaterials = new D3DMATERIAL9[m_NumMaterials];
		m_pMeshTextures = new LPDIRECT3DTEXTURE9[m_NumMaterials];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//obt@NA
	for (i = 0; i < m_NumMaterials; i++) {
		m_pMeshTextures[i] = NULL;
	}

	//eNX`t@Cǂݍ
	for (i = 0; i < m_NumMaterials; i++) {
		m_pMeshMaterials[i] = pMaterials[i].MatD3D;
		//m_pMeshMaterials[i].Ambient = m_pMeshMaterials[i].Diffuse;
		
		if (pMaterials[i].pTextureFilename == NULL) continue;
		
		//eNX`t@CpX쐬
		result = _GetTextureFilePath(
						pMeshFilePath,
						pMaterials[i].pTextureFilename,
						textureFilePath,
						_MAX_PATH
					);
		if (result != 0) goto EXIT;
		
		//eNX`t@Cǂݍ
		hresult = D3DXCreateTextureFromFile(
						pD3DDevice,
						textureFilePath,
						&(m_pMeshTextures[i])
					);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	if (pMaterialBuffer != NULL) {
		pMaterialBuffer->Release();
	}
	return result;
}

//******************************************************************************
// eNX`t@CpX擾
//******************************************************************************
int DXMesh::_GetTextureFilePath(
		TCHAR* pMeshFilePath,
		TCHAR* pTextureFileName,
		TCHAR* pBuf,
		unsigned long bufSize
	)
{
	int result = 0;
	DWORD apiresult = 0;
	errno_t eresult = 0;
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];

	//pXvf̕
	eresult = _tsplitpath_s(
					pMeshFilePath,	//bVt@CpX
					drive,			//hCuobt@
					_MAX_DRIVE,		//obt@TCY
					dir,			//fBNgobt@
					_MAX_DIR,		//obt@TCY
					fname,			//t@Cobt@
					_MAX_FNAME,		//obt@TCY
					ext,			//gqobt@
					_MAX_EXT		//obt@TCY
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//pX쐬
	eresult = _tmakepath_s(
					pBuf,			//pXi[obt@
					bufSize,		//obt@TCY
					drive,			//hCu
					dir,			//fBNg
					pTextureFileName,	//t@C
					NULL			//gq
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
void DXMesh::Transform(
		D3DXMATRIX worldMatrix
	)
{
	m_WorldMatrix = worldMatrix;
}

//******************************************************************************
// `
//******************************************************************************
int DXMesh::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	unsigned long i = 0;

	//bVǂݍłȂΉȂ
	if (m_pMesh == NULL) goto EXIT;

	//ړ}gNXZbg
	hresult = pD3DDevice->SetTransform(D3DTS_WORLD, &m_WorldMatrix);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//eNX`Xe[Wݒ
	//  J[ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	// At@ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//bV`
	for (i = 0; i < m_NumMaterials; i++) {
		//}eAݒ
		hresult = pD3DDevice->SetMaterial(&(m_pMeshMaterials[i]));
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
		
		//eNX`ݒFXe[W0
		hresult = pD3DDevice->SetTexture(0, m_pMeshTextures[i]);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
		
		//bVTuZbg`
		hresult = m_pMesh->DrawSubset(i);
		if (FAILED(hresult)) {
			result = YN_SET_ERR("DirectX API error.", hresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}


