//******************************************************************************
//
// MIDITrail / MTNoteRipple
//
// m[gg`NX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//őg`搔
#define MTNOTERIPPLE_MAX_RIPPLE_NUM  (100)

// TODO: őg`搔ςɂ
//   OɃV[PXf[^̍ő哯𒲍Ă
//   mۂobt@TCYύXł
//   łobt@TCY͏_œIɕύX\ł


//******************************************************************************
// m[gg`NX
//******************************************************************************
class MTNoteRipple
{
public:

	//RXgN^^fXgN^
	MTNoteRipple(void);
	virtual ~MTNoteRipple(void);

	//
// >>> modify 20120728 yossiepon begin
	virtual int Create(
// <<< modify 20120728 yossiepon end
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector, float rollAngle);

	//`
// >>> modify 20120728 yossiepon begin
	virtual int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
// <<< modify 20120728 yossiepon end

	//
// >>> modify 20120728 yossiepon begin
	virtual void Release();
// <<< modify 20120728 yossiepon end

	//m[gOFFo^
	void SetNoteOff(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo
		);

	//m[gONo^
	void SetNoteOn(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo,
			unsigned char velocity
		);

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
// >>> modify 20120728 yossiepon begin
	virtual void Reset();
// <<< modify 20120728 yossiepon end

	//\ݒ
	void SetEnable(bool isEnable);

	//XLbv
	void SetSkipStatus(bool isSkipping);

// >>> modify access level to protected 20120728 yossiepon begin
protected:
// >>> modify 20120728 yossiepon end

	//m[gԍ\
	struct NoteStatus {
		bool isActive;
		unsigned char portNo;
		unsigned char chNo;
		unsigned char noteNo;
		unsigned char velocity;
		unsigned long regTime;
	};

	//_obt@\
	struct MTNOTERIPPLE_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
		D3DXVECTOR2 t;	//eNX`摜ʒu
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

protected:

	//`n
	DXPrimitive m_Primitive;
	LPDIRECT3DTEXTURE9 m_pTexture;
	D3DMATERIAL9 m_Material;

	//Đ
	unsigned long m_CurTickTime;

	//J
	D3DXVECTOR3 m_CamVector;

	//m[gfUC
	MTNoteDesign* m_pNoteDesign;

	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;

	//m[gԏ
	NoteStatus* m_pNoteStatus;
	unsigned long m_ActiveNoteNum;

	//\
	bool m_isEnable;

	//XLbv
	bool m_isSkipping;

	virtual int _CreateNoteDesign();
	int _CreateTexture(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName);

// >>> modify 20161224 yossiepon begin
	virtual int _CreateNoteStatus();
	virtual int _CreateVertex(LPDIRECT3DDEVICE9 pD3DDevice);
// >>> modify 20161224 yossiepon end

	int _SetVertexPosition(
				MTNOTERIPPLE_VERTEX* pVertex,
				NoteStatus* pNoteStatus,
				unsigned long rippleNo,
				unsigned long curTime,
				bool* pIsTimeout
			);

// >>> modify 20161224 yossiepon begin
	virtual void _MakeMaterial(D3DMATERIAL9* pMaterial);
	virtual int _TransformRipple(LPDIRECT3DDEVICE9 pD3DDevice);
	virtual int _UpdateVertexOfRipple(LPDIRECT3DDEVICE9 pD3DDevice);
// >>> modify 20161224 yossiepon end

};


