//******************************************************************************
//
// MIDITrail / MTScenePianoRollRain
//
// sAm[CV[`NX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXDirLight.h"
#include "MTScene.h"
#include "MTFirstPersonCam.h"
#include "MTStars.h"
#include "MTPianoKeyboardCtrl.h"
#include "MTNoteRain.h"
#include "MTDashboard.h"
#include "MTNotePitchBend.h"
#include "MTMeshCtrl.h"
#include "MTBackgroundImage.h"
#include "MTConfFile.h"
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// sAm[CV[`NX
//******************************************************************************
class MTScenePianoRollRain : public MTScene
{
public:

	//RXgN^^fXgN^l
	MTScenePianoRollRain(void);
	virtual ~MTScenePianoRollRain(void);

	//̎擾
	const TCHAR* GetName();

	//
	virtual int Create(
			HWND hWnd,
			LPDIRECT3DDEVICE9 pD3DDevice,
			SMSeqData* pSeqData
		);

	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	void Release();

	//EBhENbNCxgM
	int OnWindowClicked(
			UINT button,
			WPARAM wParam,
			LPARAM lParam
		);

	//tJnCxgM
	int OnPlayStart(LPDIRECT3DDEVICE9 pD3DDevice);

	//tICxgM
	int OnPlayEnd(LPDIRECT3DDEVICE9 pD3DDevice);

	//V[PTbZ[WM
	int OnRecvSequencerMsg(
			unsigned long param1,
			unsigned long param2
		);

	//߂
	int Rewind();

	//_擾^o^
	virtual void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	void MoveToStaticViewpoint(unsigned long viewpointNo);

	//_Zbg
	void ResetViewpoint();

	//GtFNgݒ
	void SetEffect(MTScene::EffectType type, bool isEnable);

	//txݒ
	void SetPlaySpeedRatio(unsigned long ratio);

protected:

	//CgL
	BOOL m_IsEnableLight;

	//VOL[{[htO
	bool m_IsSingleKeyboard;

private:

	//Cg
	DXDirLight m_DirLight;

	//l̃J
	MTFirstPersonCam m_FirstPersonCam;

	//`IuWFNg
	MTStars m_Stars;
	MTPianoKeyboardCtrl m_PianoKeyboardCtrl;
	MTNoteRain m_NoteRain;
	MTNotePitchBend m_NotePitchBend;
	MTDashboard m_Dashboard;
	MTMeshCtrl m_MeshCtrl;
	MTBackgroundImage m_BackgroundImage;

	//}EXړ[h
	bool m_IsMouseCamMode;

	//][h
	bool m_IsAutoRollMode;

	//_
	MTViewParamMap m_ViewParamMap;
	MTViewParamMap m_Viewpoint2;
	MTViewParamMap m_Viewpoint3;

	//tʒu
	unsigned long m_CurTickTime;

	//XLbv
	bool m_IsSkipping;

	void _Reset();
	void _SetLightColor(DXDirLight* pLight);
	int _LoadConf();
	int _LoadConfViewpoint(MTConfFile* pConfFile, unsigned long viewpointNo, MTScene::MTViewParamMap* pParamMap);

};


