//******************************************************************************
//
// Simple MIDI Library / SMFPUCtrl
//
// _vZbTNX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMFPUCtrl.h"
#include <float.h>

#pragma fenv_access (on)

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMFPUCtrl::SMFPUCtrl(void)
{
	m_ThreadID = 0;
	m_FPUCtrl = 0;
	m_isLock = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMFPUCtrl::~SMFPUCtrl(void)
{
	//ݒJn܂܂łΉ
	if ((m_isLock) && (m_ThreadID == GetCurrentThreadId())) {
		unsigned int curCtrl = 0;
#ifndef _WIN64
		_controlfp_s(&curCtrl, m_FPUCtrl, _MCW_PC);
#endif
		m_isLock = false;
	}
}

//******************************************************************************
// xݒJn
//******************************************************************************
int SMFPUCtrl::Start(FPUPrecision precision)
{
	int result = 0;
	errno_t eresult = 0;
	unsigned int curCtrl = 0;
	unsigned int flag = 0;

	//łɐݒJnς݂ȂG[
	if (m_isLock) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//ύXO̐tO擾
	eresult = _controlfp_s(
					&m_FPUCtrl,	//݂̐䃏[h
					0,			//䃏[hFȂ
					0			//}XNFȂ
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Windows API error.", eresult, GetLastError());
		goto EXIT;
	}

	_DisplayCurCtrl(_T("Start before"));

	//_xݒ
	switch (precision) {
		case FPUSingle:
			flag = _PC_24;
			break;
		case FPUDouble:
			flag = _PC_53;
			break;
		case FPUExtended:
			flag = _PC_64;
			break;
		default:
			result = YN_SET_ERR("Program error.", 0, 0);
			goto EXIT;
	}

#ifdef _WIN64
	//x64(64bit)
	//x̕KvȂ
#else
	//x86(32bit)
	eresult = _controlfp_s(
					&curCtrl,	//݂̐䃏[h
					flag,		//䃏[hF
					_MCW_PC		//}XNFx
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Windows API error.", eresult, GetLastError());
		goto EXIT;
	}
#endif

	_DisplayCurCtrl(_T("Start after"));

	m_ThreadID = GetCurrentThreadId();
	m_isLock = true;

EXIT:;
	return result;
}

//******************************************************************************
// xݒI
//******************************************************************************
int SMFPUCtrl::End()
{
	int result = 0;
	errno_t eresult = 0;
	unsigned int curCtrl = 0;

	//ݒJnĂȂꍇ̓G[
	if (!m_isLock) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//ݒJnƈقȂXbhŐݒI邱Ƃ͂łȂ
	if (m_ThreadID != GetCurrentThreadId()) {
		result = YN_SET_ERR("Program error.", m_ThreadID, GetCurrentThreadId());
		goto EXIT;
	}

	//_x𕜌
#ifdef _WIN64
	//x64(64bit)
	//x̕KvȂ
#else
	//x86(32bit)
	eresult = _controlfp_s(
					&curCtrl,	//݂̐䃏[h
					m_FPUCtrl,	//䃏[hFݒJn_
					_MCW_PC		//}XNFx
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Windows API error.", eresult, GetLastError());
		goto EXIT;
	}
#endif

	_DisplayCurCtrl(_T("End after"));

	m_ThreadID = 0;
	m_FPUCtrl = 0;
	m_isLock = false;

EXIT:;
	return result;
}

//******************************************************************************
// xݒԊmF
//******************************************************************************
bool SMFPUCtrl::IsLocked()
{
	return m_isLock;
}

//******************************************************************************
// _䃏[h\
//******************************************************************************
void SMFPUCtrl::_DisplayCurCtrl(
		TCHAR* pTitle
	)
{
//	errno_t eresult = 0;
//	unsigned int fpuctrl = 0;
//	TCHAR msg[256];
//
//	eresult = _controlfp_s(&fpuctrl, 0, 0);
//	if (eresult != 0) goto EXIT;
//
//	_stprintf_s(
//			msg,
//			256,
//			_T("Thread ID %08X\n")
//			_T("FPUCTRL %08X\n")
//			_T("_MCW_DN %08X\n")
//			_T("_MCW_EM %08X\n")
//			_T("_MCW_IC %08X\n")
//			_T("_MCW_RC %08X\n")
//			_T("_MCW_PC %08X"),
//			GetCurrentThreadId(),
//			fpuctrl,
//			(fpuctrl & _MCW_DN), //DENORMAL
//			(fpuctrl & _MCW_EM), //荞ݗO}XN
//			(fpuctrl & _MCW_IC), //
//			(fpuctrl & _MCW_RC), //ۂߐ
//			(fpuctrl & _MCW_PC)  //x
//		);
//
//	MessageBox(NULL, msg, pTitle, MB_OK);
//
//EXIT:;
//	return;
}

} // end of namespace


