//=========================================================================
///	<summary>
///		^\tg䃂W[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Reflection;
using System.Diagnostics;
using System.Xml;
using magicAnime.Properties;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		^\tg䃉bp[NX
	///	</summary>
	/// <remarks>
	///		^\tgAvOCoRė\̓o^폜sB
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	/// <history>2007/08/15	NɑSvOCSchedulerCX^XĂ</history>
	//=========================================================================
	public class ReserveManager
	{
		//----------------
		// ^̒`
		//----------------
		internal enum ChangeResult
		{
			Dontcare,	// GȂ
			OK		,	// 
			Lost	,	// \
			Denied	,	// \𓮂Ȃ
		};
		
		//-------------------------------
		// oϐ
		//-------------------------------
		private static List<Scheduler> schedulerList;

		//=========================================================================
		///	<summary>
		///		vOCCX^XXgԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public static List<Scheduler> SchedulerList
		{
			get { return schedulerList; }
		}

		//=========================================================================
		///	<summary>
		///		SvOC[h
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal static void InitPlugins()
		{
			Assembly plugin;

			schedulerList = new List<Scheduler>();
			
			//-------------------------
			// iEPGvOCo^
			//-------------------------

			schedulerList.Add(new iEPGScheduler());

			//-----------------------------
			// vOCDLLTĔF
			//-----------------------------
			Process		my;
			string		d;
			string		[]dlls;

			my = Process.GetCurrentProcess();

			d = Path.GetDirectoryName( my.MainModule.FileName );

			dlls = Directory.GetFiles(d, "*.dll");

// <MOD> 2010/04/11 ->
			var assemblies	= new List<Assembly>();
			var modules		= new List<Module>();
			var types		= new List<Type>();
			var schedTypes	= new List<Type>();

			Array.ForEach<string>(dlls, delegate (string dll)
				{
					try
					{
						assemblies.Add( Assembly.LoadFrom(dll) );
					}
					catch(Exception ex)
					{
						// ֌WȃA}l[WhDLLȂǂ𖳎
					}
				});

			assemblies.ForEach( assey => modules.AddRange( assey.GetModules() ) );
			modules.ForEach( mod => types.AddRange( mod.GetTypes() ) );
			schedTypes = types.FindAll( type => type.IsSubclassOf(typeof(Scheduler)) );

			schedTypes.ForEach( delegate (Type type)
				{
					Scheduler sched;
					sched = Activator.CreateInstance( type ) as Scheduler;
					if ( sched != null )
						schedulerList.Add( sched );
				} );

//            foreach (string f in dlls)
//            {
//                {
//                    plugin = Assembly.LoadFrom(f);

//                    foreach (Module m in plugin.GetModules())
//                    {
//                        foreach (Type type in m.GetTypes())
//                        {
//                            if (type.IsSubclassOf(typeof(Scheduler)))
//                            {
//                                Scheduler sched;
//                                sched = Activator.CreateInstance( type ) as Scheduler;
//                                if ( sched != null )
//                                {
//                                    schedulerList.Add( sched );
//                                }
//                            }
//                        }
//                    }
//                }
//            }
// <MOD> 2010/04/11 <-
			//sched = plugin.CreateInstance("mAgicScheduler");

			//MessageBox.Show(sched.ToString());

		}

//  2008/01/03
		//=========================================================================
		///	<summary>
		///		풓ĂvOC
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal static void CleanupPlugins()
		{
			if( schedulerList != null )
			{
				foreach( Scheduler sched in schedulerList )
				{
					sched.Close();
				}
				schedulerList = null;
			}
		}
//  2008/01/03

		//=========================================================================
		///	<summary>
		///		w肳ꂽNX̃vOCCX^XԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2007/08/15 VK쐬</history>
		//=========================================================================
		public static Scheduler FindScheduler( string typeName )
		{
			foreach ( Scheduler sched in schedulerList )
			{
				if ( sched.GetType().Name.Equals( typeName ) )
					return sched;
			}
			return null;
		}

//  2007/08/15 ǉ
		//=========================================================================
		///	<summary>
		///		ftHgXPW[Ԃ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public static Scheduler DefaultScheduler
		{
			get
			{
				return FindScheduler( Settings.Default.schedulerType );
			}
		}
//  2007/08/15 ǉ

//  2007/08/16 ǉ
		//=========================================================================
		///	<summary>
		///		Scheduler^CvProfile^CvԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2007/08/16 VK쐬</history>
		//=========================================================================
		public Type GetProfileType()
		{
			throw new NotImplementedException();
		}
//  2007/08/16 ǉ

		//=========================================================================
		///	<summary>
		///		ԑgVK\񂷂
		///	</summary>
		/// <remarks>
		///		\񏈗ɏQꍇ͗O𓊂
		/// </remarks>
		/// <returns>
		///		ꍇtrue
		///		XP[Wɔ\͂Ȃꍇfalse
		/// </returns>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool MakeReservation(
			string		title		,	// ^^Cg
			string		uniqueID	,	// ^̈ӂID
			string		tvStation	,	// erǖ
			DateTime	start		,	// Jn
			uint		length		,	// ^撷
			uint		groupID		,	// ^̃O[vID
			Scheduler.Profile param	)	// tѐݒ
		{
			Scheduler sched	= DefaultScheduler;

			if (sched!=null &&
				(sched.Ability & Scheduler.AbilityFlag.MakeReservation) > 0)	// XPW[w肳āA\񂪉\H
			{

				// t@CɂĘ^t@CH
				if (Settings.Default.specifiedFile == IdentifyFileMethod.ByFileNameWithID)
				{
					title	= string.Format(
								Settings.Default.specifiedNameFormat	,
								uniqueID								,
								title									);		// ID܂񂾘^^Cgɂ
				}

				//--------------------------
				// ^\tgɗ\
				//--------------------------
				sched.MakeReservation(
					title									,
					uniqueID								,
					GetRegisteredStationName( tvStation )	,
					start									,
					(int)length								,
					title									,
					groupID									,
					param									);

				return true;
			}

			return false;
		}


		//=========================================================================
		///	<summary>
		///		\ύX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2007/05/08 CancelReservationɑΉ</history>
		//=========================================================================
		internal ChangeResult ChangeReservation(
			string		title		,	// ^^Cg
			string		uniqueID	,	// ^̈ӂID
			string		tvStation	,	// erǖ
			DateTime	start		,	// Jn
			uint		length		,	// ^撷
			uint		groupID		,	// ^̃O[vID
			Scheduler.Profile param	)	// ^ݒ
		{
			Scheduler sched = DefaultScheduler;

			if ( sched == null ) return ChangeResult.Dontcare;

			// add yossiepon 20150815 begin

			// t@CɂĘ^t@CH
			if ( Settings.Default.specifiedFile == IdentifyFileMethod.ByFileNameWithID )
			{
				title = string.Format(
					Settings.Default.specifiedNameFormat	,
					uniqueID								,
					title									); // ID܂񂾘^^Cgɂ
			}

			// add yossiepon 20150815 end

			Logger.Output("(\)ԕύX " + start.ToString() + "(" + title + ")" );

			//----------------------------
			// \Ȃ璼ڗ\ύX
			//----------------------------
			if ((sched.Ability & Scheduler.AbilityFlag.ChangeReservation) > 0)
			{
				try
				{
					sched.ChangeReservation( title, uniqueID, start, groupID, param );
				}
				catch ( Exception ex )
				{
					Logger.Output( "(\Ǘ)" + ex.Message );
					return ChangeResult.Denied;
				}

				return ChangeResult.OK;
			}

			//-----------------------------
			// LZƓo^s
			//-----------------------------
			if ( ( sched.Ability & Scheduler.AbilityFlag.CancelReservation ) > 0 )
			{
				//-----------------------
				// UAÂ\폜
				//-----------------------
				try
				{
					sched.CancelReservation( title, uniqueID );
				}
				catch ( Exception ex )
				{
					Logger.Output("(\Ǘ)" + ex.Message);
					return ChangeResult.Denied;
				}

				//-----------------------
				// ߂ė\o^
				//-----------------------
				try
				{
					// del yossiepon 20150815 begin

					//// t@CɂĘ^t@CH
					//if ( Settings.Default.specifiedFile == IdentifyFileMethod.ByFileNameWithID )
					//{
					//	title = string.Format(
					//		Settings.Default.specifiedNameFormat	,
					//		uniqueID								,
					//		title									); // ID܂񂾘^^Cgɂ
					//}

					// del yossiepon 20150815 end

					sched.MakeReservation(
						title									,
						uniqueID								,
						GetRegisteredStationName( tvStation )	,
						start									,
						(int)length								,
						title									,
						groupID									,
						param									);
				}
				catch ( Scheduler.DoubleBookingException dex )
				{
					throw;
//					return ChangeResult.Lost;
				}
				catch ( Exception ex )
				{
					throw;
				}

				return ChangeResult.OK;
			}

//  2007/10/28 vOCȂꍇDon't care
//			return ChangeResult.OK;
			return ChangeResult.Dontcare;
//  2007/10/28
		}

		//=========================================================================
		///	<summary>
		///		w肳ꂽ^CgEID̗\񂪑݂邩`FbN
		///	</summary>
		/// <remarks>
		///		߂l̓`FbN̉ہB
		/// </remarks>
		/// <history>2007/08/16 VK쐬</history>
		//=========================================================================
// <MOD> 2008/10/21 ->
		internal bool ExistReservation(
			string		title		,	// [i] ^Cg
			string		uniqueID	,	// [i] \ID
			out bool	exist		)	// [o] \񂪑݂
		//internal bool ExistReservation(
		//    string title	,
		//    string uniqueID)
// <MOD> 2008/10/21 <-
		{
			Scheduler sched;

// <MOD> 2008/10/21 ->
			sched = DefaultScheduler;

// <ADD> 2008/11/16 ftHgXPW[w肳ĂȂꍇX[ ->
			if( sched == null )
			{
				exist  = false;
				return false;
			}
// <ADD> 2008/11/16 <-

			bool existReservation = (0 < (sched.Ability & Scheduler.AbilityFlag.ExistReservation));

			if( (sched != null) && existReservation )
			{
				exist = sched.ExistReservation(title, uniqueID);

				return true;
			}

			exist = false;
			return false;
			//sched = DefaultScheduler;
			//if (sched == null) return true;

			//return sched.ExistReservation(title, uniqueID);
// <MOD> 2008/10/21 <-
		}

		//=========================================================================
		///	<summary>
		///		\폜
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2007/05/08 VK쐬</history>
		//=========================================================================
// <MOD> 2008/10/22 ->
		internal bool CancelReservation(
//		internal void CancelReservation(
// <MOD> 2008/10/22 <-
			string title		,
			string uniqueID		)
		{
			Scheduler sched;

			sched = DefaultScheduler;
// <MOD> 2008/10/22 ->
			if ( sched == null ) return false;
//			if ( sched == null ) return;
// <MOD> 2008/10/22 <-

			if ( ( sched.Ability & Scheduler.AbilityFlag.CancelReservation ) == 0 )
// <MOD> 2008/10/22 ->
				return false;
//				return;
// <MOD> 2008/10/22 <-

			sched.CancelReservation( title, uniqueID );
// <ADD> 2008/10/22 ->
			return true;
// <ADD> 2008/10/22 <-
		}


		//=========================================================================
		///	<summary>
		///		^\tgɗ\̃R~bg
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Flush()
		{
			Scheduler sched = DefaultScheduler;

			if (sched != null)
			{
				sched.Flush();
			}
		}


		//=========================================================================
		///	<summary>
		///		erǖe[uXMLpXԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static public string TvStationsXml	// <MOD> 2009/12/30
//		static private string TvStationsXml
		{
			get
			{
				string filePath;
// <MOD> 2009/12/27 ->
                filePath = Path.Combine( Program.AppDataPath, "tvStationsII.xml" );
//				filePath = Path.GetDirectoryName(Application.ExecutablePath);
//				filePath += Path.DirectorySeparatorChar;
//				filePath += "tvStationsII.xml";
// <MOD> 2009/12/27 <-
				return filePath;
			}
		}

		internal class StationTable
		{
			public string Name;			// erǖ
			public string RegName;			// o^ǖ
		};

		//=========================================================================
		///	<summary>
		///		erǖe[uǂݍ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static internal List<StationTable> LoadStationTable()
		{
			XmlReader	r;
			List<StationTable>		list	= new List<StationTable>();
			StationTable			t		= null;

			try
			{
				r = XmlReader.Create(TvStationsXml);

				while (r.Read())
				{
					if (r.NodeType == XmlNodeType.Element)
					{
						if (r.LocalName.ToUpper().Equals("STATION"))
						{
							t = new StationTable();
						}
						if (r.LocalName.ToUpper().Equals("NAME"))
						{
							t.Name = r.ReadElementContentAsString();
						}
						if (r.LocalName.ToUpper().Equals("REGNAME"))
						{
							t.RegName = r.ReadElementContentAsString();
						}

					}
					else if (r.NodeType == XmlNodeType.EndElement)
					{
						if (r.LocalName.ToUpper().Equals("STATION"))
						{
							list.Add(t);
						}
					}

				}

				r.Close();

			}catch (Exception)
			{
				list.Clear();
			}

			return list;
		}

		//=========================================================================
		///	<summary>
		///		erǖe[uɓo^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static internal void ModifyStationTable(
			string		n	,	// erǖ
			string		r	)	// o^ǖ
		{
			List<StationTable>		list	= LoadStationTable();
			bool					w		= true;				// VKǉtO

			foreach (StationTable e in list)
			{
				if (e.Name.ToUpper().Equals(n.ToUpper()))
				{
					e.RegName	= r;
					w			= false;
				}
			}

			if ( w )
			{
				StationTable e = new StationTable();

				e.Name			= n;
				e.RegName		= r;

				list.Add( e );
			}

			SaveStationTable( list );

		}

		//=========================================================================
		///	<summary>
		///		erǖe[uۑ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static internal void SaveStationTable(List<StationTable> list)
		{
			XmlTextWriter w;

			w				= new XmlTextWriter( TvStationsXml, System.Text.Encoding.UTF8);
			w.Formatting	= Formatting.Indented;

			w.WriteStartDocument();
			w.WriteStartElement("REPLACETABLE");

			foreach (StationTable e in list)
			{
				w.WriteStartElement( "STATION" );

				w.WriteElementString("NAME", e.Name );
				w.WriteElementString("REGNAME", e.RegName);

				w.WriteEndElement();
			}

			w.WriteEndElement();
			w.WriteEndDocument();
			w.Close();

		}
	
		//=========================================================================
		///	<summary>
		///		erǖe[uɁAerǖu
		///	</summary>
		/// <remarks>
		///		`ȂΌ̂̕܂ܕԂ
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static public string GetRegisteredStationName(string tvStation)
		{
			List<StationTable> list = LoadStationTable();

			foreach (StationTable e in list)
			{
				if (e.Name.ToUpper().Equals(tvStation.ToUpper()))
				{
					return e.RegName;
				}
			}

			return tvStation;
		}


		////////////////////////////////////////////////////////////////
		// FUNCTION	:	CreateDefaultScheduler
		// ABSTRACT	:	
		////////////////////////////////////////////////////////////////
//  2007/08/15 폜
		//internal static Scheduler CreateDefaultScheduler()
		//{
		//    Scheduler s;

		//    try
		//    {
		//        if (Settings.Default.schedulerType.Equals(""))
		//            return null;

		//        //
		//        // IvVŎw肳ꂽSchedulerIuWFNg쐬
		//        //
		//        s = (Scheduler)System.Activator.CreateInstance(
		//                        FindScheduler(Settings.Default.schedulerType)
		//                    );
		//    }
		//    catch (Exception)
		//    {
		//        s = null;
		//    }

		//    return s;
		//}
//  2007/08/15 폜



	}
}
