;; GCC machine description for RXv2 synchronization instructions.
;; Copyright (C) 2011-2015 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;;

(define_c_enum "unspec" [
  UNSPEC_ATOMIC
])

(define_c_enum "unspecv" [
  UNSPECV_CMPXCHG_1
  UNSPECV_CMPXCHG_2
  UNSPECV_CMPXCHG_3
])

(define_code_iterator FETCHOP [plus minus ior xor and])
(define_code_attr fetchop_name
  [(plus "add") (minus "sub") (ior "or") (xor "xor") (and "and")])

(define_code_attr fetchop_constraint_1_llcs
  [(plus "ri") (minus "r") (ior "ri") (xor "ri") (and "ri")])

;;------------------------------------------------------------------------------
;; comapre and swap

(define_expand "atomic_compare_and_swapsi"
  [(match_operand:SI 0 "register_operand")		;; bool success output
   (match_operand:SI 1 "register_operand")		;; oldval output
   (match_operand:SI 2 "memory_operand")	;; memory
   (match_operand:SI 3 "general_operand")	;; expected input
   (match_operand:SI 4 "general_operand")	;; newval input
   (match_operand:SI 5 "const_int_operand")		;; is_weak
   (match_operand:SI 6 "const_int_operand")		;; success model
   (match_operand:SI 7 "const_int_operand")]		;; failure model
  ""
{
  rtx mem = operands[2];
  rtx old_val = gen_lowpart (SImode, operands[1]);
  rtx exp_val = operands[3];
  rtx new_val = operands[4];

  emit_insn (gen_atomic_compare_and_swapsi_1 (old_val, mem,
					      exp_val, new_val));

  DONE;
})

(define_insn "atomic_compare_and_swapsi_1"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(unspec_volatile:SI
	  [(match_operand:SI 1 "memory_operand" "=q")
	   (match_operand:SI 2 "general_operand" "ri")
	   (match_operand:SI 3 "general_operand" "ri")]
	  UNSPECV_CMPXCHG_1))
   (set (match_dup 1)
	(unspec_volatile:SI [(const_int 0)] UNSPECV_CMPXCHG_2))
   (set (reg:SI CC_REG)
	(unspec_volatile:SI [(const_int 0)] UNSPECV_CMPXCHG_3))
  (clobber (reg:SI CC_REG))
  (clobber (reg:SI R1_REG))]
  "ALLOW_RXV2_INSNS"
  "\r0:	movli	%1,r1
	cmp	%2,r1
	bne	0f
	mov	r1,%0
	mov	%3,r1
	movco	r1,%1
	tst	r1,r1
	bne	0b
0:"
  [(set_attr "length" "19")])

;;------------------------------------------------------------------------------
;; read - write - return old value
(define_insn "atomic_exchangesi"
  [(set (match_operand:SI 0 "register_operand" "=&r")	;; oldval output
   (match_operand:SI 1 "memory_operand" "=m"))		;; memory
   (match_operand:SI 3 "const_int_operand")		;; memory model
   (set (match_dup 1)
	(match_operand:SI 2 "register_operand" "0"))]		;; input
  ""
  "xchg %1,%0"
  [(set_attr "length" "4")])

;;------------------------------------------------------------------------------
;; read - add|sub|or|and|xor|nand - write - return old value

(define_insn "atomic_fetch_<fetchop_name>si"
  [(set (match_operand:SI 0 "register_operand" "=&mr")
	(match_operand:SI 1 "memory_operand" "=mr"))
   (set (match_dup 1)
	(unspec:SI
	  [(FETCHOP:SI (match_dup 1)
	     (match_operand:SI 2 "general_operand" "g"))]
	  UNSPEC_ATOMIC))
   (match_operand:SI 3 "const_int_operand")
   (clobber (reg:SI CC_REG))
   (clobber (reg:SI R1_REG))]
  "ALLOW_RXV2_INSNS"
  "\r0:	movli	%1,r1
	mov	r1,%0
	<fetchop_name>	%2,r1
	movco	r1,%1
	tst	r1,r1
	beq	0b";
  [(set_attr "length" "15")])

(define_insn "atomic_fetch_nandsi"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(match_operand:SI 1 "memory_operand" "=q"))
   (set (match_dup 1)
	(unspec:SI
	  [(not:SI (and:SI (match_dup 1)
		       (match_operand:SI 2 "general_operand" "ri")))]
	  UNSPEC_ATOMIC))
   (match_operand:SI 3 "const_int_operand")
   (clobber (reg:SI CC_REG))
   (clobber (reg:SI R1_REG))]
  "ALLOW_RXV2_INSNS"
  "\r0:	movli	%1,r1
	mov	r1,%0
	and	%2,r1
	not	r1
	movco	r1,%1
	tst	r1,r1
	beq	0b"
  [(set_attr "length" "16")])

;;------------------------------------------------------------------------------
;; read - add|sub|or|and|xor|nand - write - return new value

(define_insn "atomic_<fetchop_name>_fetchsi"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(FETCHOP:SI
	  (match_operand:SI 1 "memory_operand" "=m")
	  (match_operand:SI 2 "general_operand" "ri")))
   (set (match_dup 1)
	(unspec:SI
	  [(FETCHOP:SI (match_dup 1) (match_dup 2))]
	  UNSPEC_ATOMIC))
   (match_operand:SI 3 "const_int_operand" "")
   (clobber (reg:SI CC_REG))]
  "ALLOW_RXV2_INSNS"
  "\r0:	movli	%1,%0
	<fetchop_name>	%2,%0
	movco	%0,%1
	tst	%0,%0
	beq	0b
	mov.L	%1,%0"
  [(set_attr "length" "15")])

(define_insn "atomic_nand_fetchsi"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(not:SI (and:SI
	  (match_operand:SI 1 "memory_operand" "=q")
	  (match_operand:SI 2 "general_operand" "ri"))))
   (set (match_dup 1)
	(unspec:SI
	  [(not:SI (and:SI (match_dup 1) (match_dup 2)))]
	  UNSPEC_ATOMIC))
   (match_operand:SI 3 "const_int_operand")
   (clobber (reg:SI CC_REG))]
  "ALLOW_RXV2_INSNS"
  "\r0:	movli	%1,%0
	and	%2,%0
	not	%0
	movco	%0,%1
	tst	%0,%0
	bf	0b
	mov.L	%1,%0"
  [(set_attr "length" "16")])
