/*
 * Startup Code for Spansion FM3
 *
 * Copyright (c) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm/io.h>

#define PLL_SCM_CTL   0x40010000
#define PLL_SCM_STR   0x40010004
#define PLL_BSC_PSR   0x40010010
#define PLL_APBC0_PSR 0x40010014
#define PLL_APBC1_PSR 0x40010018
#define PLL_APBC2_PSR 0x4001001C
#define PLL_CSW_TMR   0x40010030
#define PLL_PSW_TMR   0x40010034
#define PLL_PLL_CTL1  0x40010038
#define PLL_PLL_CTL2  0x4001003C

#define WDT_CTL     0x40011008
#define WDT_LCK     0x40011C00

void s_init(void)
{
	writel(0x1acce551, WDT_LCK);
	writel(0xe5331aae, WDT_LCK);
	writel(0x00000000, WDT_CTL);

	writeb(0x4d, PLL_CSW_TMR);
	writeb(0x02, PLL_SCM_CTL);
	while (!(readb(PLL_SCM_STR) & 0x02));
	writeb(0x06, PLL_PSW_TMR);
	writeb(0x01, PLL_PLL_CTL1);
	writeb(35, PLL_PLL_CTL2);
	writeb(0x12, PLL_SCM_CTL);
	while (!(readb(PLL_SCM_STR) & 0x10));

	writeb(0x00, PLL_BSC_PSR);
	writeb(0x02, PLL_APBC0_PSR);
	writeb(0x82, PLL_APBC1_PSR);
	writeb(0x82, PLL_APBC1_PSR);
	writeb(0x52, PLL_SCM_CTL);
}
