/*
 * armboot - Startup Code for Cortex-M CPU-core
 *
 * Copyright (c) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm-offsets.h>
#include <config.h>
#include <linux/linkage.h>

	.syntax	unified
	.arch	armv7-m
	.thumb
	.thumb_func

	.word	CONFIG_SYS_INIT_SP_ADDR
	.word	_start
	.word	nmi
	.word	hard_fault
	
ENTRY(_start)
	bl	lowlevel_init
	ldr	r0,=_sdata_lma
	ldr	r1,=_sdata
	ldr	r2,=_edata
1:	ldmia	r0!,{r3}
	stmia	r1!,{r3}
	cmp	r1,r2
	blo	1b
	b	_main
ENDPROC(_start)

ENTRY(c_runtime_cpu_setup)
	bx	lr
ENDPROC(c_runtime_cpu_setup)

ENTRY(nmi)
	stmdb	sp!,{r4-r11}
	mov	r0, sp
	bl	do_nmi
ENDPROC(nmi)
ENTRY(hard_fault)
	stmdb	sp!,{r4-r11}
	mov	r0, sp
	bl	do_hf
ENDPROC(hard_fault)

.globl _TEXT_BASE
_TEXT_BASE:
#if defined(CONFIG_SPL_BUILD) && defined(CONFIG_SPL_TEXT_BASE)
	.word	CONFIG_SPL_TEXT_BASE
#else
	.word	CONFIG_SYS_TEXT_BASE
#endif
.globl _bss_start_ofs
_bss_start_ofs:
	.word __bss_start - _start

.globl _bss_end_ofs
_bss_end_ofs:
	.word __bss_end - _start

.globl _end_ofs
_end_ofs:
	.word _end - _start
.globl IRQ_STACK_START_IN
IRQ_STACK_START_IN:
	.word	0x0badc0de

