/*
 * Copyright (C) 2011 Yoshinori Sato <ysato@users.sourceforge.jp>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#if CONFIG_SYS_TEXT_BASE > 0xfff00000
	.section	".vector","ax"
	.global	_start
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff

	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff

	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (20 * 4)	/* 20 privillege exception */
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (23 * 4)	/* 23 illigal instruction */

	.long	0xffffffff
	.long	__ram_vec + (25 * 4)	/* 25: floating point exception */
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (30 * 4)	/* 30: nmi */
	.long	_start
#endif

	.text
	.align	2
_start:
	mov	#__stack, r0
	bsr	lowlevel_init

#if CONFIG_SYS_TEXT_BASE > 0xfff00000
	mov	#_fdata,r1
	mov	#_edata,r3
	sub	r1,r3
	mov	#_etext,r2
	smovf
#else
	mov	#__bss_start,r1
	mov	#__bss_end,r3
	sub	r1,r3
	mov	#0,r2
	sstr
#endif
	mov	r0,r1
	bsr	board_init_f_mem
	mov	r1,r0
	mov	#0,r1
	bsr	board_init_f
	
	bra	.

	.global	relocate_code
relocate_code:
	mov.l	r1,r0
	mov.l	r2,r1
	mov.l	r3,r2
	bra	board_init_r

	.end
