/*
 * (C) Copyright 2011 Yoshinori Sato
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#include <asm/processor.h>

	.global	lowlevel_init

	.text
	.align	2

lowlevel_init:
	mov.l	#0x00080000, r1
	/* unlock */
	add	#0x3fe, r1, r2
	mov.w	#0xa503, [r2]
	/* HOCO off */
	mov.b	#0x01, 0x36[r1]
	add	#0xc294, r1, r2
	mov.b	#0x01, [r2]
	/* Main OSC enable */
	add	#0xa2, r1, r2
	mov.b	#41, [r2]
	add	#0x32, r1, r2
	mov.b	#0, [r2]
1:	mov.b	[r2], r3
	cmp	#0, r3
	bne	1b
	/* Wait for main OSC stable */
2:	btst	#0, 0x3c[r1].b
	beq	2b
	/* PLL out:x20 source:osc in:/2 */
	mov.w	#0x2701, 0x28[r1]
	mov.b	#0x00, 0x2a[r1]
	/* Wait for PLL stable */
3:	btst	#2, 0x3c[r1].b
	beq	3b
	/* Flash/4 Core/2 Bus/4 PclkA/2 PclkB-D/4 Out Enable */
	mov.l	#0x21021222, 0x20[r1]
	/* USB/5 */
	mov.w	#0x0041, 0x24[r1]
	/* Source PLL */
	mov.w	#0x0400, 0x26[r1]
	rts

	.end
