/*
 * Copyright (C) 2015 Yoshinori Sato
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
OUTPUT_FORMAT("elf32-rx-le")
OUTPUT_ARCH(rx)
ENTRY(_start)

MEMORY {
	iram : ORIGIN = 0x0000100, LENGTH = 512K - 256
	sdram : ORIGIN = 0x08000000, LENGTH = 16M
	irom : ORIGIN = 0xfffc0000, LENGTH = 256K - 128
	vector : ORIGIN = 0xffffff80, LENGTH = 128
}

SECTIONS
{
	.text :
	{
		PROVIDE (_ftext = .);
		PROVIDE (_fcode = .);
			PROVIDE (_start = .);

		KEEP(arch/rx/cpu/rxv2/start.o (.text))
		*(.text)
		. = ALIGN(4);
		PROVIDE (_ecode = .);
	} > irom
	.rodata :
	{
		*(SORT_BY_ALIGNMENT(SORT_BY_NAME(.rodata*)))
		. = ALIGN(4);
	} > irom
	.u_boot_list : {
		KEEP(*(SORT(.u_boot_list*)));
	} > irom
	PROVIDE (_etext = .);

	. = 0xffffff80;
	.vector :
	{
		*(.vector);
	} > vector

	PROVIDE (__ram_vec = 0x00000000);

	.data :
	{
		PROVIDE (_fdata = .);
		*(.data)
		*(.stack)
		. = ALIGN(4);
		PROVIDE (_edata = .);
	} > iram AT>irom
	_iram_start = _etext + SIZEOF(.data);
	.iram.text :
	{
		_iram_text = .;
		*(.iram.text)
		_iram_text_end = .;
	} > iram AT>irom

	.bss :
	{
		PROVIDE (__bss_start = .);
		*(.bss*)
		. = ALIGN(4);
	} > iram
	PROVIDE (__bss_end = .);
	PROVIDE (__init_end = .);

	PROVIDE (__stack = 0x00040000);

	PROVIDE (_end = .);
}
