/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import org.omegat.core.Core;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

/**
 *
 * @author Yu Tang
 */
public class MenuManager {

    private JMenu root;
    private ShellLinkMenu currentProject;
    private ShellLinkMenuItem currentSourceFile;
    private ShellLinkMenuItem currentTargetFile;

    public MenuManager() {
        root = createLocalizedMenu(L10n.get(L10n.Key.FOLDERS_MENU_LABEL));  // Folders menu
        root.addMenuKeyListener(MenuHelper.getMenuKeyListener()); // for opening folder with enter key
        root.addMenuListener(MenuHelper.getRootMenuListener());
        
        // ProjectRoot
        try {
            currentProject = new ShellLinkMenu(L10n.get(L10n.Key.PROJECT_ROOT_MENU_LABEL));
            root.add(currentProject.getMenu());
        } catch (IOException ex) {
            Log.log(ex);
            return;
        }

        // User Config
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            root.add(new ShellLinkMenu(confDir, L10n.get(L10n.Key.USER_CONFIG_MENU_LABEL)).getMenu());
        } catch (IOException ex) {
            Log.log(ex);
        }

        // ---- separator ----
        root.add(new JSeparator());

        // Current Source File
        currentSourceFile = new ShellLinkMenuItem(L10n.get(L10n.Key.SOURCE_DOC_MENU_LABEL));
        root.add(currentSourceFile.getMenuItem());

        // Current Target File
        currentTargetFile = new ShellLinkMenuItem(L10n.get(L10n.Key.TARGET_DOC_MENU_LABEL));
        root.add(currentTargetFile.getMenuItem());

        // insert Files menu before the last menu (Help menu.)
        JMenuBar mainMenuBar = (JMenuBar) Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add(root, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            currentProject.link(rootDir);
        } catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        currentProject.unlink();
    }

    public void linkCurrentSourceFile(File file) throws IOException {
        String sourceRoot = Core.getProject().getProjectProperties().getSourceRoot();
        String midName = FileUtil.computeRelativePath(new File(sourceRoot), file);
        currentSourceFile.link(file, midName);
    }

    public void unlinkCurrentSourceFile() {
        currentSourceFile.unlink();
    }

    public void linkCurrentTargetFile(File file) throws IOException {
        String targetRoot = Core.getProject().getProjectProperties().getTargetRoot();
        String midName = FileUtil.computeRelativePath(new File(targetRoot), file);
        currentTargetFile.link(file, midName);
    }

    public void unlinkCurrentTargetFile() {
        currentTargetFile.unlink();
    }

    private JMenu createLocalizedMenu(String labelString) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText(m, labelString);
        return m;
    }
}