/**************************************************************************
 Stats2Excel - open Statistics with Excel from standard Tools menu.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Properties;
import org.omegat.util.OConsts;

/**
 *
 * @author Yu-Tang
 */
public class Settings {
    
    private final File file;
    private final Properties properties;

    // Key
    private final String TEMPLATE_VERSION = "TemplateVersion";

    public Settings(File file) throws IOException {
        this.file = file;
        properties = new Properties(getDefaultProperties());

        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                FileInputStream in = new FileInputStream(file);
                reader  = new BufferedReader(new InputStreamReader(in, OConsts.UTF8));
                properties.load(reader);
            } finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                } catch(IOException ex) { /* ignore */ }
            }
        }
    }

    public String getTemplateVersion() {
        return properties.getProperty(TEMPLATE_VERSION);
    }

    public void setTemplateVersion(String versionString) {
        properties.setProperty(TEMPLATE_VERSION, versionString);
    }

    public void save() throws IOException {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            properties.store(writer, null);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch(IOException ex) { /* ignore */ }
        }
    }

    private Properties getDefaultProperties() {
        Properties p = new Properties();

        // set default property here
        p.setProperty(TEMPLATE_VERSION, "V1");

        return p;
    }
}
