/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.foldermenu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;

/**
 *
 * @author Yu-Tang
 */
public class MenuHelper {

    static {
        fs = FileSystemView.getFileSystemView();
        ff = new FileFilter() {

            @Override
            public boolean accept(File file) {
                // except dot started named files (i.e. ".svn") and hidden files
                return !file.getName().startsWith(".") && !file.isHidden();
            }

        };

        al = new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) { $(e).open(); }
            
        };

        mkl = new MenuKeyListener() {

            @Override
            public void menuKeyTyped(MenuKeyEvent e) { /* do nothing */ }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ENTER) {
                    MenuSelectionManager manager = e.getMenuSelectionManager();
                    MenuElement[] selectedPath = manager.getSelectedPath();
                    MenuElement selection = selectedPath[selectedPath.length-1];
                    if (selection instanceof JMenu) {
                        JMenu menu = (JMenu) selection;
                        if (menu.isEnabled()) {
                            manager.clearSelectedPath();
                            $(menu).open();
                        }
                    }
                }
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) { /* do nothing */ }

        };

        mol = new MouseListener() {

            @Override
            public void mouseClicked(MouseEvent e) { $(e).open(); }

            @Override
            public void mousePressed(MouseEvent e) { /* do nothing */ }

            @Override
            public void mouseReleased(MouseEvent e) { /* do nothing */ }

            @Override
            public void mouseEntered(MouseEvent e) { /* do nothing */ }

            @Override
            public void mouseExited(MouseEvent e) { /* do nothing */ }
            
        };
        
        mel = new MenuListener() {

            @Override
            public void menuSelected(MenuEvent e) {
                // Lazy create submenus
                $(e).createChildren();
            }

            @Override
            public void menuDeselected(MenuEvent e) { /* do nothing */ }

            @Override
            public void menuCanceled(MenuEvent e) { /* do nothing */ }
            
        };
        
        /* for Folders root menu only */
        melRoot = new MenuListener() {
            
            @Override
            public void menuSelected(MenuEvent e) { /* do nothing */ }

            @Override
            public void menuDeselected(MenuEvent e) {
                // remove children's all menuitems
                JMenu menu = (JMenu) e.getSource();
                for (Component c: menu.getMenuComponents()) {
                    if (c instanceof JMenu) {
                        JMenu m = (JMenu) c;
                        if (m.isEnabled())
                            m.removeAll();
                    }
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) { /* do nothing */ }

        };

        comp = new Comparator<File>() {

            @Override
            public int compare(File f1, File f2) {
                if (f1.isFile() == f2.isFile()) {
                    return f1.getName().compareToIgnoreCase(f2.getName());
                } else {
                    return f1.isFile() ? 1 : -1;
                }
            }

        };
    }

    private MenuHelper() {} // no instanciation, static only.

    public static Icon getIcon(File file) {
        return fs.getSystemIcon(file);
    }

    public static File[] getFilteredListFiles(File folder) {
        return folder.listFiles(ff);
    }

    public static ActionListener getActionListener() {
        return al;
    }

    public static MenuKeyListener getMenuKeyListener() {
        return mkl;
    }

    public static MouseListener getMouseListener() {
        return mol;
    }

    public static MenuListener getMenuListener() {
        return mel;
    }

    public static MenuListener getRootMenuListener() {
        return melRoot;
    }

    public static Comparator<File> getComparator() {
        return comp;
    }

    private static ShellLinkMenuItem $(JMenuItem mi) {
        return new ShellLinkMenuItem(mi);
    }

    private static ShellLinkMenu $(JMenu m) {
        return new ShellLinkMenu(m);
    }

    private static ShellLinkMenuItem $(ActionEvent e) {
        return new ShellLinkMenuItem((JMenuItem) e.getSource());
    }

    private static ShellLinkMenu $(MouseEvent e) {
        return new ShellLinkMenu((JMenu) e.getSource());
    }

    private static ShellLinkMenu $(MenuEvent e) {
        return new ShellLinkMenu((JMenu) e.getSource());
    }

    private static final FileSystemView  fs;
    private static final FileFilter       ff;
    private static final ActionListener   al;
    private static final MenuKeyListener  mkl;
    private static final MouseListener    mol;
    private static final MenuListener     mel;
    private static final MenuListener     melRoot;
    private static final Comparator<File> comp;

}
