package com.jm;

import java.io.Serializable;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.ListView;

import com.jm.db.Dao;
import com.jm.utility.BaseActivity;
import com.jm.utility.JmException;
import com.jm.utility.ListViewArrayAdapter;
import com.jm.utility.Resource;

public class Menu2 extends BaseActivity {
	private int index = -1;
	private ListView listView = null;
	private JmPattern[] list = null;
	private int topPosition = -1;
	private int topPositionY = 0;
	
	private static JmPattern[] listGen = null;

	public static void setList(JmPattern[] list){
		listGen = list;
	}
	
	public static JmPattern[] getList(){
		return listGen;
	}
	
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.menu2);

	    Bundle extras = getIntent().getExtras();
	    index = extras.getInt("INDEX");
	    if (index == Menu1.INDEX7){
	    	list = listGen;
	    }
	    else {
		    try {
		    	list = Dao.getInstance().get(index);
		    	listGen = list; // svł
		    }
		    catch (JmException e){
		    	showDialog(this, e);	    	
		    	return;
		    }
	    }
	    
	    if (list == null){
	    	// ȉ̎菇ŃG[
	    	// 1. p^[ʂŃp^[𐶐
			// 2. XgʂJ
	    	// 3. vZXobNOEhɂ
	    	// 4. OS̃AvɃ蓖Ă邽߂ɃvZXI
	    	// 5. ċN
	    	finish();
	    	return;
	    }
	    
		listView = (ListView)findViewById(R.id.Menu2);
		ListViewArrayAdapter adapter = new ListViewArrayAdapter(
				this, android.R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);

		listView.setOnItemClickListener(new OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				if (index == Menu1.INDEX6 && position == 0){
					Intent intent = new Intent(Menu2.this, (Class<?>)Edit.class);
					intent.putExtra("MODE", Edit.NEW);
					intent.putExtra("ID", list[position].getId());
					startActivityForResult(intent, -1);				
				}
				else if (index == Menu1.INDEX7){
					initJuggleView();
					
					topPosition = listView.getFirstVisiblePosition();
					topPositionY = listView.getChildAt(0).getTop();
					
					Intent intent = new Intent(Menu2.this, (Class<?>)JuggleView.class);
					intent.putExtra("INDEX1", index);
					intent.putExtra("INDEX2", position);
					intent.putExtra("ID", -1);
					intent.putExtra("PATTERN", (Serializable)list[position]);
					startActivityForResult(intent, -1);					
				}
				else {
					initJuggleView();
					
					topPosition = listView.getFirstVisiblePosition();
					topPositionY = listView.getChildAt(0).getTop();
					
					Intent intent = new Intent(Menu2.this, (Class<?>)JuggleView.class);
					intent.putExtra("INDEX1", index);
					intent.putExtra("INDEX2", position);
					intent.putExtra("ID", list[position].getId());
					startActivityForResult(intent, -1);
				}
			}			
		});
		
		listView.setOnItemLongClickListener(new OnItemLongClickListener(){
			@Override
			public boolean onItemLongClick(AdapterView<?> arg0, View arg1,
					int position, long arg3) {
				if (index == Menu1.INDEX6 && position == 0){
					return false;
				}
				if (index == Menu1.INDEX7){
					return false;
				}
				Intent intent = new Intent(Menu2.this, (Class<?>)Edit.class);
				intent.putExtra("MODE", Edit.EDIT);
				intent.putExtra("INDEX1", index);
				intent.putExtra("ID", list[position].getId());
				startActivityForResult(intent, -1);				
				return true;
			}
		});
    }
	
	@Override
	protected void onRestart() {
		super.onRestart();
		
		if (index == Menu1.INDEX7){
			list = listGen;
		}
		else if (index >= 0) {
			try {
				list = Dao.getInstance().get(index);
			} catch (JmException e) {
				showDialog(this, e);
				return;
			}
		}
		ListViewArrayAdapter adapter = new ListViewArrayAdapter(
				this, android.R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);
		
		if (topPosition >= 0){
			// XgIʒu
			listView.setSelectionFromTop(topPosition, topPositionY);
		}
	}

	private void initJuggleView(){
        Resource.cx = 0.0f;
        Resource.cy = 0.0f;
        Resource.counter = 0;
        
        JuggleView.init();
	}
}
