function JugglerCanvas(i, j, c_id){
	this.initialize.apply(this, [i, j, c_id]);
}

JugglerCanvas.DENOMINATOR = 1000;
JugglerCanvas.color = [
	0x0000ff, 0xff0000, 0xffff00, 0x00ff00,
	0xffa000, 0xa0522d, 0xff7f2b, 0x87ceeb, 
	0xb03060, 0xffc0cb,	0xff00ff, 0xa020f0,
	0x00ffff
];

JugglerCanvas.prototype = {
	diameter: 0,
	center: 0,
	base: 60,
	magnification: 400,
	ssHeight: 0,
	jp: null,
	handler: null,
	balls: null,
	graphics: null,
	counter: - 1,
	initialize: function(i, j, c_id) {
		this.graphics = new Graphics(c_id);
		this.handler = new Juggler();
// todo
		var obj = patternList.get(i, j);
		this.handler.start(obj);
	},
	onDrawInit: function(){
		center = this.getWidth() / 2;
		this.graphics.translate(center, 0);
		this.setImageHeight(Ball.balls.getYRange());
		this.createBalls(this.handler.getSiteSwap().getNumberOfBalls());
	},
	onDraw: function() {
		if (this.counter < 0){
			this.onDrawInit();
			this.counter = 0;
		}
		this.handler.drawJuggler(this.counter);
		this.counter++;
	},
	setForegroundColor: function(){
		;
	},
	setBackgroundColor: function(){
		;
	},
	setEmphasisColor: function(){
		;
	},
	setImageHeight: function(yrange){
		this.magnification = JugglerCanvas.DENOMINATOR;
		var height = this.getHeight() - this.ssHeight;
		if (yrange > 0) {
			this.magnification = this.magnification * height / yrange;
		}
		this.base = this.getHeight()
			- 55 * this.magnification / JugglerCanvas.DENOMINATOR;
	},
	createBalls: function(number) {
		this.diameter = this.translateR(Ball.RADIUS) * 2;
		if (this.diameter < 2){
			this.diameter = 2;
		}
	},
	clear: function(){
		this.graphics.fillRect(
			-this.center, this.ssHeight, this.getWidth(), this.getHeight());
	},
	drawBall: function(i, x, y){
		x = this.translateX(x);
		y = this.translateY(y);
		this.graphics.drawImage(i, x, y, this.diameter / 2);
	},
	drawLine: function(x1, y1, x2, y2) {
		x1 = this.translateX(x1);
		y1 = this.translateY(y1);
		x2 = this.translateX(x2);
		y2 = this.translateY(y2);
		this.graphics.drawLine(x1, y1, x2, y2);
	},
	drawCircle: function(x, y, r){
		x = this.translateX(x);
		y = this.translateY(y);
		r = this.translateR(r);
		this.graphics.drawCircle(x, y, r);
	},
	drawString: function(str, x, y, anchor, color) {
		this.graphics.drawString(str, x, y, anchor, color);
	},
	translateX: function(x) {
		if (JmPattern.ifMirror()){
			x = -x;
		}
		return this.translate(x);
	},
	translateY: function(y) {
		return this.translate(y) + this.base;
	},
	translateR: function(r) {
		return this.translate(r);
	},
	translate: function(t) {
		return t * this.magnification / JugglerCanvas.DENOMINATOR;
	},
	getWidth: function(){
		return this.graphics.getWidth();
	},
	getHeight: function(){
		return this.graphics.getHeight();
	}
};
