function SiteSwap(){
	this.initialize.apply(this);
}

SiteSwap.MAP = new Array();
SiteSwap.MAX_N_SITESWAP = 255;
SiteSwap.MAX_N_MULTIPLEX = 11;
SiteSwap.CROSS = asc('x') - asc('a') + 10;
SiteSwap.COMMA = -1;  
SiteSwap.BRA = -2;
SiteSwap.KET = -3;
SiteSwap.PAR = -4;
SiteSwap.ENTHESIS = -5;
SiteSwap.ERROR = Number.MIN_VALUE;

SiteSwap.getInstance = function(siteswapStr) {
//	if (MAP.containsKey(siteswap)){
//		return MAP.get(siteswap);
//	}
//	var ss = new SiteSwap();
//	if (!ss.setSiteswap(siteswap)){
//		return null;
//	}
//	MAP.put(siteswap, ss);
	if (SiteSwap.MAP[siteswapStr]){
		return SiteSwap.MAP[siteswapStr];
	}
	var ss = new SiteSwap();							
	if (!ss.setSiteswap(siteswapStr)){
		return null;
	}
	SiteSwap.MAP[siteswapStr] = ss;
	return ss;
}

SiteSwap.clearCashe = function(){
	SiteSwap.MAP = new Array();
}

SiteSwap.toSiteswapString = function(b){
	var ret = "";
	if (b < 0) {
		b = -b;
		ret = "x";
	}
	if (b < 10){
		return b + ret;
	}
	return (asc('a') + b - 10) + ret;
}

SiteSwap.toSiteswapByte = function(c) {
	switch(c) {
	case '(' : return SiteSwap.PAR;
	case ')' : return SiteSwap.ENTHESIS;
	case ',' : return SiteSwap.COMMA;
	case '[' : return SiteSwap.BRA;
	case ']' : return SiteSwap.KET;
	default:
		c = asc(c);
		if (asc('0') <= c && c <= asc('9')){
			return c - asc('0');
		}
		else if (asc('a') <= c && c <= asc('z')){
			return c - asc('a') + 10;
		}
		else if (asc('A') <= c && c <= asc('Z')){
			return c - asc('A') + 10;
		}
	}
	return SiteSwap.ERROR;
}

SiteSwap.prototype = {
	siteswap: null,
	isSynchronousVal: false,
	maxValue: 0,
	number: 0,

	initialize: function() {

	},
	getValue: function(i, j) {
		i = i % this.siteswap.length;
		return this.siteswap[i][j % this.siteswap[i].length];
	},
	getMaxValue: function() {
		return this.maxValue;
	},
	getNumberOfBalls: function() {
		return this.number;
	},
	isSynchronous: function() {
		return this.isSynchronousVal;
	},
	size: function() {
		return this.siteswap.length;
	},
	setSize: function(index) {
		return this.siteswap[index % this.siteswap.length].length;
	},
	getStrings: function() {
		if (this.isSynchronous()){
			return this.getSynStrings();
		}
		var ret = new Array(this.siteswap.length);
		var i;
		for(i = 0; i < this.siteswap.length; i++){
			ret[i] = this.getString(i);
		}
		return ret;
	},
	getSynStrings: function() {
		var ret = new Array(toInt(this.siteswap.length / 2));
		var i;
		for(i = 0; i < ret.length; i++) {
			ret[i] = '(' + this.getString(i*2) + ','
				+ this.getString(i*2+1) + ')';
		}
		return ret;
	},
	getString: function(i) {
		if (this.siteswap[i].length == 0){
			return "0";
		}
		if (this.siteswap[i].length == 1){
			return SiteSwap.toSiteswapString(this.siteswap[i][0]);
		}
		var p = "[";
		var j;
		for (j = 0; j < this.siteswap[i].length; j++){
			p += SiteSwap.toSiteswapString(this.siteswap[i][j]);
		}
		p += ']';
		return p;
	},
	toString: function() {
		var str = "";
		var s = this.getStrings();
		var i;
		for (i = 0; i < s.length; i++)
			str += s[i];
		return str;
	},
	setSiteswap: function(s) {
		if (this.number != 0){
			return false;
		}
		if (s == null){
			return false;
		}
		s = s.trim();
		if (s.length < 0){
			return false;
		}
		if (s.length > SiteSwap.MAX_N_SITESWAP){
			return false;
		}
		if (s.charAt(0) == '('){
			this.isSynchronousVal = true;
		}
		var parenthesisFlag = 0;
		var braketFlag = false;
		var patt = getArray2(s.length, SiteSwap.MAX_N_MULTIPLEX, -1);
		var patts = new Array(s.length);
		var pattw = 0;
		var a = 0;

		var ch;
		for (ch = 0; ch < s.length; ch++) {
			var t = SiteSwap.toSiteswapByte(s.charAt(ch));
			switch (t) {
			case SiteSwap.ERROR:
				return false;
			case SiteSwap.BRA:				// [
				braketFlag = true;
				patts[pattw] = 0;
				continue;
			case SiteSwap.KET:				// ]
				if (!braketFlag){
					return false;
				}
				braketFlag = false;
				pattw++;
				continue;
			case SiteSwap.PAR:				// (
				if (!this.isSynchronousVal){
					return false;
				}
				if (parenthesisFlag != 0){
					return false;
				}
				parenthesisFlag = 1;
				continue;
			case SiteSwap.ENTHESIS:			// )
				if (!this.isSynchronousVal){
					return false;
				}
				if (parenthesisFlag != 5){
					return false;
				}
				parenthesisFlag = 0;
				continue;
			case SiteSwap.COMMA:			// ,
				if (!this.isSynchronousVal){
					return false;
				}
				if (parenthesisFlag != 2){
					return false;
				}
				parenthesisFlag = 4;
				continue;
			case SiteSwap.CROSS:			// x
				if (!this.isSynchronousVal){
					break;
				}
				if (parenthesisFlag != 2 && parenthesisFlag != 5){
					return false;
				}
				if (braketFlag){
					patt[pattw][patts[pattw] - 1] = -a;
				}
				else {
					patt[pattw - 1][0] = -a;
				}
				continue;
			}
			a = t;
			if (this.isSynchronousVal) {
				if (a % 2 != 0){
					return false;
				}
				if (!braketFlag
					&& parenthesisFlag != 1
					&& parenthesisFlag != 4){
					return false;
				}
				if (parenthesisFlag == 1){
					parenthesisFlag = 2;
				}
				else if (parenthesisFlag == 4){
					parenthesisFlag = 5;
				}
			}
			if (braketFlag) {
				if (a == 0){
					return false;
				}
				patt[pattw][patts[pattw]++] = a;
				if (patts[pattw] > SiteSwap.MAX_N_MULTIPLEX){

					return false;
				}
			}
			else {
				patt[pattw][0] = a;
				if (a == 0){
					patts[pattw++] = 0;
				}
				else {
					patts[pattw++] = 1;
				}
			}
		}
		if (parenthesisFlag != 0 || braketFlag || pattw == 0){
			return false;
		}
		this.siteswap = new Array(pattw);
		var i;
		for (i = 0; i < this.siteswap.length; i++) {
			this.siteswap[i] = new Array(patts[i]);
			var j;
			for (j = 0; j < this.siteswap[i].length; j++) {
				this.siteswap[i][j] = patt[i][j];
				var b = Math.abs(this.siteswap[i][j]);
				this.number += b;
				this.maxValue = Math.max(this.maxValue, b);
			}
		}
		if (this.number % this.siteswap.length != 0){
			return false;
		}
		this.number /= this.siteswap.length;
		if (this.number == 0){
			return false;
		}
		return true;
	}
}

