/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_UNISTD_H_) && !defined(_UNISTD_H)
#  include <unistd.h>
#endif

/*//========================================================================\\*
 *|| Jpeg check                                                             ||*
 *\\========================================================================//*/
/*******************************************************************************
 * png check IHDL *************************************************************/
static int png_chk_ihdl (picInfo *pinfo, unsigned char *data, off_t len)
{
  pinfo->img_x = ((unsigned long)(*data)<<24)|((unsigned long)(*(data+1))<<16)|((unsigned long)(*(data+2))<<8)|(unsigned long)(*(data+3));data+=4;
  pinfo->img_y = ((unsigned long)(*data)<<24)|((unsigned long)(*(data+1))<<16)|((unsigned long)(*(data+2))<<8)|(unsigned long)(*(data+3));data+=4;
  if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("img_x: %ld, img_y: %ld\n", pinfo->img_x, pinfo->img_y);}
  
  pinfo->fm = 0;
  return 1;

  pinfo->fm = 1;
  return 0;
}

/*******************************************************************************
 * png check(jpg,jpeg) *******************************************************/
void png_chk (int fd, picInfo *pinfo)
{
  unsigned int  masize;
  unsigned char *ifpot, *ifoff, br;
  off_t         rlen, off_set, size;
  unsigned int  crc, crc_chk, hl;
  int           i, rrtn;
  
  pinfo->fm = 0;
  /*******************************************************************
   * Get File size and allocate memory ******************************/
  masize = MIN((unsigned int)pinfo->fsize, (unsigned int)MAXMALLOCSIZE);
  if ((ifpot=(unsigned char *)malloc_init (masize))==NULL) {return ;}
  ifoff = ifpot;
  br = rlen = off_set = 0;

  
  /*-Get packet info from input file and dividing flow Start--------*/
  while ((rrtn=read (fd, ifoff, (masize-rlen)))>=0) {
    rlen = (off_t)rrtn + rlen;
    if (rlen<0) {free (ifpot); return;}
    ifoff = ifpot;
    if (off_set==0 && rlen==0) {pinfo->fm = 1; br=1; break;}

    /*-Get packet info from read data Start-------------------------*/
    while (rlen>=8) {
      if (off_set==0) { /* SOL */
	if (rlen<8) {br=1; break;}
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("PNG identifier\n");}
	if (!(*(ifoff+0)==0x89 && *(ifoff+1)==0x50 && *(ifoff+2)==0x4e && *(ifoff+3)==0x47 &&
	      *(ifoff+4)==0x0d && *(ifoff+5)==0x0a && *(ifoff+6)==0x1a && *(ifoff+7)==0x0a)) {
	  pinfo->fm = 1;
	  br=1; break;
	}
	size = 8;
      } else {
	hl = ((off_t)*(ifoff+0)<<24)|((off_t)*(ifoff+1)<<16)|((off_t)*(ifoff+2)<<8)|((off_t)*(ifoff+3));
	/*printf ("size: 0x%8X, %u\n", hl, hl);*/
	if (rlen<(hl+12)) {if ((hl+12)>masize) {br=1; pinfo->fm = 2;}break;}
	size = (off_t) (hl+12);
	/***** crc check *****/
	crc = crc_chk = 0;
	crc = ((unsigned int)*(ifoff+hl+8)<<24)|((unsigned int)*(ifoff+hl+9)<<16)|((unsigned int)*(ifoff+hl+10)<<8)|((unsigned int)*(ifoff+hl+11));
	crc_chk = crc; /* crc code */
	/*printf ("crc: 0x%8X\n", crc);*/
	if ((crc^crc_chk)!=0) {br=1; pinfo->fm = 1; break;}

	if (*(ifoff+4)=='I' && *(ifoff+5)=='H' && *(ifoff+6)=='D' && *(ifoff+7)=='R') {png_chk_ihdl (pinfo, (ifoff+8), hl);}
      }
      /*if (1 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("size: 0x%4X%\n", size);}*/
      
      if (pinfo->img_x!=0 && pinfo->img_y!=0) {br=1; break;}
      rlen -= size; ifoff += size; off_set += size;
    }
    if (br) {break;}
    
    
    /*-Get packet info from read data End---------------------------*/
    for (i=0; i<rlen; i++) {*(ifpot+i) = *(ifoff+i);}
    ifoff = ifpot + rlen;
  }
  if (pinfo->img_x==0 || pinfo->img_y==0) {pinfo->fm = 1;}
  /*-Get packet info from input file and dividing flow End----------*/
  free (ifpot);

  return ;
}

