/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#ifndef MACRO_H__
#define MACRO_H__ __DATE__

/*******************************************************************************
 * Flagment processing ********************************************************/
#define FLGINIT(a)      (*a=0)                          /* Flag initialise    */
#define FLGSET(a,b)     (*a|=b)                         /* Set flag bit       */
#define FLGCLR(a,b)     (*a^=(*a&b))                    /* Clear flag bit     */
#define FLGTGR(a,b)     (*a^=b)                         /* Toggle flag bit    */
#define FLGCHK(a,b)     ((a&b)==b?1:0)                  /* Check flag bit     */

#endif /* MACRO_H__ */
