package hayashi.kiban;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.areaweb.tools.database.*;

public class DbBusstop
{
	String idref = "";
	String name = "";
	Double lat = 0.0D;
	Double lon = 0.0D;
	int fixed = 0;
	String ifile = "";

	public DbBusstop() {
		idref = "";
		name = "";
		lat = 0.0D;
		lon = 0.0D;
		fixed = 0;
		ifile = "";
	}

	/** メイン
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException, SQLException
	{
		Connection con = null;
		try {
			con = DatabaseTool.openDb("database");
			DbBusstop.export(con);
		}
		finally {
			if (con != null) {
				DatabaseTool.closeDb(con);
			}
		}
	}

	/**
	 * 'table.BUS_STOP'を新規に作る
	 *
	 * TABLE "bus_stop"	(
	 * 		idref VARCHAR(12) NOT NULL,
	 * 		name VARCHAR(128),
	 * 		lat DOUBLE,
	 * 		lon DOUBLE,
	 * 		fixed INT,
	 * 		ifile VARCHAR(128),
	 * 		CONSTRAINT bus_stop_pk PRIMARY KEY(idref)
	 * )
	 *
	 * @param con
	 * @throws SQLException
	 */
	public static void create(Connection con) throws SQLException {
		String createSt = "CREATE TABLE bus_stop (idref VARCHAR(12) NOT NULL, name VARCHAR(128), lat DOUBLE, lon DOUBLE, fixed INT, ifile VARCHAR(128), CONSTRAINT bus_stop_pk PRIMARY KEY(idref));";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * 'table.BUS_STOP'を削除する
	 * @param con
	 * @throws SQLException
	 */
	public static void drop(Connection con) throws SQLException {
		String createSt = "DROP TABLE bus_stop;";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * データベースの初期化
	 * @param con
	 */
	public static void initDb(Connection con) {
		// 'table.BUS_STOP'を削除する
		try {
			DbBusstop.drop(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_stop] is not created.");
		}

		// 'table.BUS_STOP'を新規に作る
		try {
			DbBusstop.create(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_stop] is already created.");
		}
	}

	/**
	 * 'table.BUS_STOP'の内容をCSV形式にして標準出力に出力する
	 * @param con
	 */
	public static void export(Connection con) {
		try {
			System.out.println("TABLE: BUS_STOP");
			System.out.println("\"idref\",\"name\",\"lat\",\"lon\",\"fixed\",\"ifile\"");
			PreparedStatement ps8 = con.prepareStatement("SELECT idref,name,lat,lon,fixed,ifile FROM bus_stop");
			ResultSet rset8 = ps8.executeQuery();
			while (rset8.next()) {
				String idref = rset8.getString("idref");
				String name = rset8.getString("name");
				Double lat = rset8.getDouble("lat");
				Double lon = rset8.getDouble("lon");
				int fixed = rset8.getInt("fixed");
				String ifile = rset8.getString("ifile");
				System.out.println("\""+ idref +"\",\""+ name +"\","+ lat +","+ lon +","+ fixed +",\""+ ifile +"\"");
			}
			rset8.close();
		}
		catch (SQLException e) {
			e.printStackTrace();
		}
	}

	public static void get(Connection con, DbBusstop bean, String idref) throws SQLException {
		PreparedStatement ps8 = con.prepareStatement("SELECT name,lat,lon,fixed,ifile FROM bus_stop WHERE idref=?");
		ps8.setString(1, idref);
		ResultSet rset8 = ps8.executeQuery();
		if (rset8.next()) {
			bean.name = rset8.getString(1);
			bean.lat = rset8.getDouble(2);
			bean.lon = rset8.getDouble(3);
			bean.fixed = rset8.getInt(4);
			bean.ifile = rset8.getString(5);
			bean.idref = idref;
		}
		rset8.close();
	}

	/**
	 *
	 * @param con
	 * @param idref
	 * @param lat
	 * @param lon
	 * @param fixed
	 * @throws SQLException
	 */
	public static void setPosition(Connection con, String idref, double lat, double lon, int fixed) throws SQLException {
		System.out.println("BusStop.setPosition (\""+ idref +"\", "+ lat +", "+ lon +", "+ fixed +")");
		DbBusstop bean = new DbBusstop();
		DbBusstop.get(con,  bean, idref);
		if (bean.idref.equals(idref)) {
			PreparedStatement ps6 = con.prepareStatement("UPDATE bus_stop SET lat=?,lon=?,fixed=? WHERE idref=?");
			ps6.setDouble(1, lat);
			ps6.setDouble(2, lon);
			ps6.setInt(3, fixed);
			ps6.setString(4, idref);
			ps6.executeUpdate();
		}
		else {
			PreparedStatement ps2 = con.prepareStatement("INSERT INTO bus_stop (lat,lon,fixed,idref) VALUES (?,?,?,?)");
			ps2.setDouble(1, lat);
			ps2.setDouble(2, lon);
			ps2.setInt(3, fixed);
			ps2.setString(4, idref);
			ps2.executeUpdate();
		}
	}

	public static void setName(Connection con, String idref, String name, String iFileName) throws SQLException {
		System.out.println("BusStop.setName (\""+ idref +"\",\""+ name +"\", \""+ iFileName +"\")");
		DbBusstop bean = new DbBusstop();
		DbBusstop.get(con,  bean, idref);
		if (bean.idref.equals(idref)) {
			PreparedStatement ps6 = con.prepareStatement("UPDATE bus_stop SET name=?,ifile=? WHERE idref=?");
			ps6.setString(1, name);
			ps6.setString(2, iFileName);
			ps6.setString(3, idref);
			ps6.executeUpdate();
		}
		else {
			PreparedStatement ps2 = con.prepareStatement("INSERT INTO bus_stop (name,ifile,idref) VALUES (?,?,?)");
			ps2.setString(1, name);
			ps2.setString(2, iFileName);
			ps2.setString(3, idref);
			ps2.executeUpdate();
		}
	}
}