/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 2;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        Object[] objectArray = session.rowActionList.getArray();
        int n = session.rowActionList.size();
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                if (((RowAction)object).canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                ((RowAction)object).prepareCommit(session);
            }
            for (n2 = 0; n2 < session.tempSet.size(); ++n2) {
                object = ((RowActionBase)session.tempSet.get((int)n2)).session;
                ((Session)object).abortTransaction = true;
            }
            n2 = 1;
            return n2 != 0;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int n = session.rowActionList.size();
        Object[] objectArray = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                if (((RowAction)object).canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                ((RowAction)object).commit(session);
            }
            for (n2 = 0; n2 < session.tempSet.size(); ++n2) {
                object = ((RowActionBase)session.tempSet.get((int)n2)).session;
                ((Session)object).abortTransaction = true;
            }
            this.persistCommit(session, objectArray, n);
            n2 = session.rowActionList.size();
            if (n2 > n) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(session, objectArray, n, n2, session.actionTimestamp);
                this.finaliseRows(session, objectArray, n, n2, true);
                session.rowActionList.setSize(n);
            }
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp || session == this.lobSession) {
                this.mergeTransaction(session, objectArray, 0, n, session.actionTimestamp);
                this.finaliseRows(session, objectArray, 0, n, true);
            } else if (session.rowActionList.size() > 0) {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPartial(Session session, int n, long l) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction != null) {
                rowAction.rollback(session, l);
                continue;
            }
            System.out.println("null action in rollback " + n);
        }
        this.writeLock.lock();
        try {
            this.mergeRolledBackTransaction(session, l, objectArray, n, n2);
            this.finaliseRows(session, objectArray, n, n2, false);
        }
        finally {
            this.writeLock.unlock();
        }
        session.rowActionList.setSize(n);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction = this.addDeleteActionToRow(session, table, row, nArray);
        Session session2 = null;
        boolean bl = true;
        if (rowAction == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl2 = bl = !session.tempSet.isEmpty();
                if (bl) {
                    session2 = ((RowActionBase)session.tempSet.get((int)0)).session;
                    session.tempSet.clear();
                    if (session2 != null) {
                        bl = this.checkDeadlock(session, session2);
                    }
                }
                if (bl) {
                    session.redoAction = true;
                    if (session2 != null) {
                        session2.waitingSessions.add(session);
                        session.waitedSessions.add(session2);
                        session.latch.countUp();
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        Session session2 = null;
        boolean bl = false;
        boolean bl2 = true;
        HsqlException hsqlException = null;
        if (rowAction == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        if (table.tableType == 5) {
            this.rowActionMap.put(rowAction.getPos(), rowAction);
        }
        try {
            persistentStore.indexRow(session, row);
        }
        catch (HsqlException hsqlException2) {
            if (session.tempSet.isEmpty()) {
                throw hsqlException2;
            }
            bl = true;
            hsqlException = hsqlException2;
        }
        if (!bl) {
            session.rowActionList.add(rowAction);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase rowActionBase = (RowActionBase)session.tempSet.get(0);
            session2 = rowActionBase.session;
            session.tempSet.clear();
            if (rowActionBase.commitTimestamp != 0L) {
                bl2 = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    bl = false;
                    break;
                }
                default: {
                    bl = this.checkDeadlock(session, session2);
                }
            }
            if (bl) {
                session.redoAction = true;
                if (bl2) {
                    session2.waitingSessions.add(session);
                    session.waitedSessions.add(session2);
                    session.latch.countUp();
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(hsqlException, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean canRead(Session session, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (n == 0) {
            if (rowAction == null) {
                return true;
            }
            return rowAction.canRead(session, 0);
        }
        if (n == 2) {
            boolean bl = rowAction == null ? true : rowAction.canRead(session, 0);
            return bl;
        }
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public boolean canRead(Session session, int n, int n2) {
        RowAction rowAction = (RowAction)this.rowActionMap.get(n);
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n2);
    }

    @Override
    public void setTransactionInfo(CachedObject cachedObject) {
        RowAction rowAction;
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        row.rowAction = rowAction = (RowAction)this.rowActionMap.get(row.position);
    }

    @Override
    public void removeTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        this.rowActionMap.remove(cachedObject.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] objectArray;
            long l2;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionTimestamps.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.isTransaction) {
            return;
        }
        if (statement == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    return;
                }
            }
            session.isPreTransaction = true;
            if (!this.isLockedMode && !statement.isCatalogLock()) {
                return;
            }
            this.beginActionTPL(session, statement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
                ++this.transactionCount;
            }
            session.isPreTransaction = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RowAction addDeleteActionToRow(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction = null;
        Row row2 = row;
        synchronized (row2) {
            if (table.tableType != 5) return RowAction.addDeleteAction(session, table, row, nArray);
            Lock lock = this.rowActionMap.getWriteLock();
            lock.lock();
            try {
                rowAction = (RowAction)this.rowActionMap.get(row.getPos());
                if (rowAction == null) {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                    if (rowAction == null) return rowAction;
                    this.rowActionMap.put(row.getPos(), rowAction);
                } else {
                    row.rowAction = rowAction;
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                }
            }
            finally {
                lock.unlock();
            }
            return rowAction;
        }
    }

    void endTransaction(Session session) {
        long l = session.transactionTimestamp;
        int n = this.liveTransactionTimestamps.indexOf(l);
        if (n >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            session2.waitedSessions.remove(session);
            session2.latch.countDown();
        }
        session.waitingSessions.clear();
    }

    void getTransactionSessions(HashSet hashSet) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            long l = sessionArray[i].getTransactionTimestamp();
            if (this.liveTransactionTimestamps.contains(l)) {
                hashSet.add(sessionArray[i]);
                continue;
            }
            if (sessionArray[i].isPreTransaction) {
                hashSet.add(sessionArray[i]);
                continue;
            }
            if (!sessionArray[i].isTransaction) continue;
            hashSet.add(sessionArray[i]);
        }
    }

    @Override
    void endTransactionTPL(Session session) {
        Session session2;
        int n;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session session3 = null;
        session.waitingSessions.size();
        for (n = 0; n < session.waitingSessions.size(); ++n) {
            session2 = (Session)session.waitingSessions.get(n);
            Statement statement = session2.sessionContext.currentStatement;
            if (statement == null || !statement.isCatalogLock()) continue;
            session3 = session2;
            break;
        }
        if (session3 == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (n = 0; n < session.waitingSessions.size(); ++n) {
                session2 = (Session)session.waitingSessions.get(n);
                if (session2 == session3) continue;
                session2.waitedSessions.add(session3);
                session3.waitingSessions.add(session2);
                session2.latch.countUp();
            }
            this.catalogWriteSession = session3;
        }
        this.unlockTxTs = session.actionTimestamp;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement statement) {
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (statement.isCatalogLock() && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionTimestamp;
            this.lockSessionId = session.getId();
            this.getTransactionSessions(session.tempSet);
            session.tempSet.remove(session);
            if (!session.tempSet.isEmpty()) {
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (statement.getTableNamesForWrite().length > 0) {
            if (statement.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                return true;
            }
        } else if (statement.getTableNamesForRead().length > 0) {
            if (statement.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                return true;
            }
        } else {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.countUp();
        }
        return true;
    }
}

