package hayashi.kiban;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.areaweb.tools.database.*;

public class DbBusref
{
	/** メイン
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException, SQLException
	{
		Connection con = null;
		try {
			con = DatabaseTool.openDb("database");
			DbBusref.export(con);
		}
		finally {
			if (con != null) {
				DatabaseTool.closeDb(con);
			}
		}
	}

	/**
	 * 'table.BUS_REF'を新規に作る
	 *
	 * TABLE bus_ref (
	 * 		idref VARCHAR(12),
	 * 		code INT
	 * )
	 *
	 * @param con
	 * @throws SQLException
	 */
	public static void create(Connection con) throws SQLException {
		String createSt = "CREATE TABLE bus_ref (idref VARCHAR(12), code INT);";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * 'table.BUS_REF'を削除する
	 * @param con
	 * @throws SQLException
	 */
	public static void drop(Connection con) throws SQLException {
		String createSt = "DROP TABLE bus_ref;";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * テーブルの初期化
	 * @param con
	 */
	public static void initDb(Connection con) {
		// 'table.bus_ref'を削除する
		try {
			DbBusref.drop(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_ref] is not created.");
		}

		// 'table.bus_ref'を新規に作る
		try {
			DbBusref.create(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_ref] is already created.");
		}
	}

	/**
	 * 'table.BUS_REF'の内容をCSV形式にして標準出力に出力する
	 * @param con
	 */
	public static void export(Connection con) {
		try {
			System.out.println("TABLE: BUS_REF");
			System.out.println("\"idref\",\"code\"");
			PreparedStatement ps8 = con.prepareStatement("SELECT idref,code FROM bus_ref");
			ResultSet rset8 = ps8.executeQuery();
			while (rset8.next()) {
				String idref = rset8.getString("idref");
				int code = rset8.getInt("code");
				System.out.println("\""+ idref +"\","+ code);
			}
			rset8.close();
		}
		catch (SQLException e) {
			e.printStackTrace();
		}
	}
}