package hayashi.yuu.tools.properties;

import hayashi.yuu.tools.logger.LoggerFactory;
import hayashi.yuu.tools.properties.Properties;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * プロパティ項目をGUIで操作する。
 * @author hayashi
 * @version 2010/02/07
 * @since 2010/02/04
 */
@SuppressWarnings("serial")
public abstract class PropertyItem extends JPanel implements ActionListener {
	hayashi.yuu.tools.properties.Properties prop;
	String propertyName;
	JLabel label;
	JComponent field;
	String value;
	Logger logger;
	public static final int ITEM_WIDTH_1 = 160;
	public static final int ITEM_WIDTH_2 = 240;
    public static final int LINE_WIDTH = ITEM_WIDTH_1 + ITEM_WIDTH_2;
    public static final int LINE_HEIGHT = 18;
	
    /**
     * コンストラクタ
     * @param prop
     * @param name
     * @param editable
     */
	public PropertyItem(Properties prop, String name, String title, boolean editable) {
		super(null);
		logger = LoggerFactory.getInstance();
		this.propertyName = name;
		this.prop = prop;
	}
	
	void createItem(String name, String title, String value, boolean editable) {
		setupLabel(title, value);
		setupField(name, value, editable);
		
		label.setBounds(0, 0, ITEM_WIDTH_1 - 6, LINE_HEIGHT);
		field.setBounds(ITEM_WIDTH_1, 0, ITEM_WIDTH_2, LINE_HEIGHT);
		setPreferredSize(new Dimension(ITEM_WIDTH_1, LINE_HEIGHT));
	}
	
	JLabel setupLabel(String title, String value) {
		label = new JLabel(title, JLabel.RIGHT);
		add(label);
		return label;
	}
	
	public String getValue() {
		return value;
	}
	
	/**
	 * コーディング例：
	 * 
	 * 	void setupField(String name, String title, String value, boolean editable) {
	 * 		this.value = value;
	 * 		((JTextField)field).setText(value);
	 * 		field.setFont(new Font("MS UI Gothic", Font.PLAIN, 12));
	 * 		if (!editable) {
	 * 			field.setEnabled(editable);
	 * 		}
	 * 		add(field);
	 * 	}
	 */
	abstract void setupField(String name, String value, boolean editable);

	/**
	 * [反映]ボタンがクリックされたときの処理
	 * 	
	 * 	public void actionPerformed(ActionEvent e) {
	 * 		System.out.println("[反映] "+ label.getText() +" = "+ text.getText());
	 * 		prop.setProperty(label.getText(), text.getText());
	 * 	}
	 * @param e
	 */
	public abstract void actionPerformed(ActionEvent e);
}
