package jp.co.areaweb.tools.command;
import java.io.*;

/**
 * ディレクトリのサイズを求める
 *
 * @author kls040
 * @version 3.0
 */
public class DirSize {
    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        String outputfile;
        
        if (args.length < 1) {
            outputfile = ".";
        }
        else {
            outputfile = args[0];
        }

        try {
            System.out.println(DirSize.size(new File(outputfile)) +"\t"+ outputfile);
        }
        catch(Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
    }
    
    static long size(File file) throws IOException {
        long size = 0L;
        if (file == null) {
            System.out.println("ERR: ディレクトリが見つかりませんでした。");
            return size;
        }
        
        if (file.isDirectory()) {
            File files[] = file.listFiles();
            if (files != null) {
                for (int i=0; i < files.length; i++) {
                    size += size(files[i]);
                }
            }
        }
        else {
            size = file.length();
        }
        return size;
    }

}
