package jp.co.areaweb.tools.gui;
import java.awt.*;
import java.io.*;
import javax.swing.*;

/**
 * 本プログラムのメインクラス
 */
@SuppressWarnings("serial")
public class Manager extends JFrame
{
	public static final String PROGRAM_NAME = "ミニプログラム";
	public static final String PROGRAM_VARSION = "0.1";
	public static final String PROGRAM_UPDATE = "2006/03/13";
	
    // Used for addNotify check.
    boolean fComponentsAdjusted = false;
    
    //{{DECLARE_CONTROLS
    JTextArea textArea;
    //JTextPane textPane;
    //}}

    //{{DECLARE_MENUS
    java.awt.MenuBar mainMenuBar;
    java.awt.Menu menu1;
    java.awt.MenuItem miDoNewFileList;
    java.awt.MenuItem miDoDirSize;
    java.awt.MenuItem miDoReadXML;
    java.awt.MenuItem miExit;
    java.awt.Menu menu3;
    java.awt.MenuItem miAbout;
    //}}

    class SymWindow extends java.awt.event.WindowAdapter {
        /**
         * このFrameが閉じられるときの動作。
         * 終了確認のパネルを表示して、[OK]が押されたら終了する
         */
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == Manager.this)
                DbMang_WindowClosing(event);
        }
    }

    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == miAbout) {
                miAbout_Action(event);
            }
            else if (object == miDoNewFileList) {
                miDoNewFileList_Action(event);
            }
            else if (object == miDoDirSize) {
                miDoDirSize_Action(event);
            }
            else if (object == miDoReadXML) {
                miDoReadXML_Action(event);
            }
            else if (object == miExit) {
                miExit_Action(event);
            }
        }
    }

	/**
	 * データベース内のテーブルを一覧で表示するFrame
	 */
    public Manager()
    {
        // INIT_CONTROLS
        //setLayout(new BorderLayout());
        Container container = getContentPane();
        container.setLayout(new BorderLayout());
        setVisible(false);
        setSize(getInsets().left + getInsets().right + 500,getInsets().top + getInsets().bottom + 480);
        setTitle(Manager.PROGRAM_NAME +" v"+ Manager.PROGRAM_VARSION);
        
        // 説明文
        textArea = new JTextArea(5,20);
        textArea.setEditable(false);
        try {
            textArea.append("1.メニュー[File]-["+ NewFileListDialog.TITLE +"]\n");
            textArea.append("\t指定された時刻以降に更新されたファイルをリストアップする\n");
            textArea.append("\n\n");

            textArea.append("2.メニュー[File]-["+ DirSizeDialog.TITLE +"]\n");
            textArea.append("\tディレクトリのファイル利用量を調べる\n");
            textArea.append("\n\n");

            textArea.append("3.メニュー[File]-["+ ReadXMLDialog.TITLE +"]\n");
            textArea.append("\tファイルが整形式XML文書であるかどうかを調べる\n");
            textArea.append("\n\n");

            BufferedReader br = new BufferedReader(new FileReader(new File("README.txt")));
            String line;
            while((line = br.readLine()) != null) {
                textArea.append(line + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            textArea.append(e.toString());
        }
        this.getContentPane().add("Center", textArea);
        
        // INIT_MENUS
        menu1 = new java.awt.Menu("File");
        miDoNewFileList = new java.awt.MenuItem(NewFileListDialog.TITLE);
        miDoNewFileList.setFont(new Font("Dialog", Font.PLAIN, 12));
        menu1.add(miDoNewFileList);
        miDoDirSize = new java.awt.MenuItem(DirSizeDialog.TITLE);
        miDoDirSize.setFont(new Font("Dialog", Font.PLAIN, 12));
        menu1.add(miDoDirSize);
        miDoReadXML = new java.awt.MenuItem(ReadXMLDialog.TITLE);
        miDoReadXML.setFont(new Font("Dialog", Font.PLAIN, 12));
        menu1.add(miDoReadXML);
        
        miExit = new java.awt.MenuItem("Quit");
        miExit.setFont(new Font("Dialog", Font.PLAIN, 12));
        menu1.add(miExit);

        miAbout = new java.awt.MenuItem("About Manager...");
        miAbout.setFont(new Font("Dialog", Font.PLAIN, 12));

        menu3 = new java.awt.Menu("Help");
        menu3.setFont(new Font("Dialog", Font.PLAIN, 12));
        menu3.add(miAbout);

        mainMenuBar = new java.awt.MenuBar();
        mainMenuBar.setHelpMenu(menu3);
        mainMenuBar.add(menu1);
        mainMenuBar.add(menu3);
        setMenuBar(mainMenuBar);
        

        //{{REGISTER_LISTENERS
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        miAbout.addActionListener(lSymAction);
        miDoNewFileList.addActionListener(lSymAction);
        miDoDirSize.addActionListener(lSymAction);
        miDoReadXML.addActionListener(lSymAction);
        miExit.addActionListener(lSymAction);
        //}}
    }

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b	trueのときコンポーネントを表示; その他のとき, componentを隠す.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b) {
        if(b) {
            setLocation(50, 50);
            
        }
        super.setVisible(b);
    }

	/**
	 * このクラスをインスタンスを生成して表示する。
	 * コマンドラインの引数はありません。
	 */    
    static public void main(String args[]) {
        (new Manager()).setVisible(true);
    }

    public void addNotify()	{
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();

        super.addNotify();

        if (fComponentsAdjusted)
            return;

        // Adjust components according to the insets
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++){
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }

    void DbMang_WindowClosing(java.awt.event.WindowEvent event)	{
        setVisible(false);  // hide the Manager
        dispose();			// free the system resources
        System.exit(0);		// close the application
    }

    void miAbout_Action(java.awt.event.ActionEvent event) {
        // Action from About Create and show as modal
        (new AboutDialog(this, true)).setVisible(true);
    }
    
    /**
     * メニュー[NewFileList]をセレクトしたときの動作
     * @param event
     */
    void miDoNewFileList_Action(java.awt.event.ActionEvent event) {
        (new NewFileListDialog(this)).setVisible(true);
    }
    
    /**
     * メニュー[DirSize]をセレクトしたときの動作
     * @param event
     */
    void miDoDirSize_Action(java.awt.event.ActionEvent event) {
        (new DirSizeDialog(this)).setVisible(true);
    }
    
    /**
     * メニュー[ReadXML]をセレクトしたときの動作
     * @param event
     */
    void miDoReadXML_Action(java.awt.event.ActionEvent event) {
        (new ReadXMLDialog(this)).setVisible(true);
    }
    
    
    void miExit_Action(java.awt.event.ActionEvent event) {
        // Action from Exit Create and show as modal
        (new QuitDialog(this, true)).setVisible(true);
    }
}
