/************************************************************
Copyright (C) 2004-2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj;

/**
* A collection of constants for following functions.
* <ul>
* <li>SDL system initialization and finalization</li>
* <li>Byte order</li>
* </ul>
* @author  SAWAI, Masahiko
**/
public interface SDLSystemConstants
{
	/**
	* Initializes the timer subsystem.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_TIMER = 0x00000001;

	/**
	* Initializes the audio subsystem.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_AUDIO = 0x00000010;

	/**
	* Initializes the video subsystem.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_VIDEO = 0x00000020;

	/**
	* Initializes the cdrom subsystem.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_CDROM = 0x00000100;

	/**
	* Initializes the joystick subsystem.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_JOYSTICK = 0x00000200;

	/**
	* Prevents  SDL from catching fatal signals.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_NOPARACHUTE = 0x00100000;

	/**
	* 
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_EVENTTHREAD = 0x01000000;

	/**
	* Initialize all of the above.
	* @see SDLSystem.init()
	* @see SDLSystem.initSubSystem()
	* @see SDLSystem.quitSubSystem()
	* @see SDLSystem.wasInit()
	**/
	int SDL_INIT_EVERYTHING = 0x0000FFFF;

	/**
	* Little endian constant 
	* @see SDLSystem.byteOrder()
	**/
	int SDL_LIL_ENDIAN = 1234;

	/**
	* Big endian constant 
	* @see SDLSystem.byteOrder()
	**/
	int SDL_BIG_ENDIAN = 4321;
}
