/************************************************************
Copyright (C) 2004-2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj;

/**
* The <code>Version</code> class represents version number of library.
* This class is immutable.
* @author Masahiko SAWAI
* @see sdl4gcj.Sys#compiledVersion() : Version
* @see sdl4gcj.Sys#linkedVersion() : Version
**/
public class Version
{
	private int major;
	private int minor;
	private int patch;
	private String versionString = null;

	public Version(int major, int minor, int patch)
	{
		this.major = major;
		this.minor = minor;
		this.patch = patch;
	}

	/**
	* Returns the major version number as integer.
	* @return major version 
	**/
	public int getMajor() { return this.major; }

	/**
	* Returns the minor version number as integer.
	* @return minor version 
	**/
	public int getMinor() { return this.minor; }

	/**
	* Returns the patch level as integer.
	* @return patch level 
	**/
	public int getPatch() { return this.patch; }

	/**
	* Compares this version to the specified object.
	* The result is <code>true</code> if and only if the 
	* arguments is not <code>null</code> and is a <code>Version</code> object 
	* that represents the same version as thie object.
	* @param obj  the object to compare this <code>Version</code> 
	*                  against.
	* @return <code>true</code> if the <code>Version</code> are equal, 
	*         <code>false</code> otherwise.
	**/
	public boolean equals(Object obj)
	{
		return (obj instanceof Version ) && 
			(this.major == ((Version)obj).major) &&
			(this.minor == ((Version)obj).minor) &&
			(this.patch == ((Version)obj).patch);
	}

	public int hashCode ()
	{
		return this.major * 100 + this.minor * 10 + this.patch;
	}

	/**
	* Returns the string representation of the reciever.
	* @return a string representation
	**/
	public String toString ()
	{
		if (versionString == null)
			versionString = this.major + "." +this.minor + "." + this.patch;
		return versionString;
	}
}
