package sdl4gcj.mixer;

import sdl4gcj.SDLException;
import java.io.File;


public class Music implements MixerConstants
{
	// instance variables
	protected gnu.gcj.RawData implementation = null;

	// class methods
	public static Music loadMUS(String filePath)
	{
		return new Music(filePath);
	}

	public static Music loadMUS(File file)
	{
		return new Music(file.getAbsolutePath());
	}

	// constructors
	public Music(String filePath)
	{
		this.loadMusicFromFile(filePath);
	}

	public Music(File file)
	{
		this.loadMusicFromFile(file.getAbsolutePath());
	}

	private Music()
	{
	}

	// instance methods
	public native void freeMusic();

	public native int getMusicType();

	protected void finalize() throws Throwable
	{
		this.freeMusic();
		super.finalize();
	}

	private native void loadMusicFromFile(String filePath);
}

