
import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;

import sdl4gcj.ttf.TTFSystem;
import sdl4gcj.ttf.Font;

public class FontTest implements  SDLConstants
{
	static final String DEFAULT_FONT_FILE_PATH = "fonts/Gill_Sans_MT.ttf";

	public static void main(String[] args)
	{
		if (SDLSystem.init(SDL_INIT_VIDEO) != 0) System.exit(0);
		if (TTFSystem.init() != 0) System.exit(0);

		try
		{
			// init screen
			SDLOptionParser optParser = new SDLOptionParser(
				640, 480, 32, 
				Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
			args = optParser.parse(args);

			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(),
				optParser.getScreenHeight(),
				optParser.getBitsPerPixel(),
				optParser.getVideoFlags());

			// init message surfaces
			String fontFilePath = DEFAULT_FONT_FILE_PATH;
			if (args.length > 0)
			{
				fontFilePath = args[0];
			}
			Font font = Font.openFont(fontFilePath, 24);
			int fontHeight = font.fontHeight();

			String[] messages = {
				" SDL_ttf Compiled Version : " + TTFSystem.compiledVersion(),
				" SDL_ttf Linked Version : " + TTFSystem.linkedVersion(),
				" ",
				" Font Filename : " + fontFilePath,
				" fontFaceFamilyName : " + font.fontFaceFamilyName(),
				" fontFaceStyleName : " + font.fontFaceStyleName(),
				" fontFaceIsFixedWidth : " + font.fontFaceIsFixedWidth(),
				" fontHeight : " + font.fontHeight(),
				" fontAscent : " + font.fontAscent(),
				" fontDescent : " + font.fontDescent(),
				" fontLineSkip : " + font.fontLineSkip(),
				" fontFaces : " + font.fontFaces(),
			};

			Surface[] messageSurfaces = new Surface[messages.length];
			for (int i = 0;i < messages.length;i++)
			{
				messageSurfaces[i] = font.renderTextBlended(messages[i], Color.WHITE);
			}
			font.closeFont();
			font = null;

			screen.fillRect(screen.mapRGB(0x0, 0x00, 0x0));
			int y = fontHeight;
			for (int i = 0;i < messageSurfaces.length;i++)
			{
				screen.blitSurface(messageSurfaces[i], 0, y);
				y += fontHeight;
			}

			screen.updateRect();

			// event loop
			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
				case SDL_KEYDOWN :
					switch (event.keydown.sym)
					{
					case SDLK_q :
					case SDLK_ESCAPE :
						done = true;
						break;
					}
					break;
				case SDL_QUIT :
					done = true;
					break;
				default:
					break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			TTFSystem.quit();
			SDLSystem.quit();
		}

		return ;
	}
}

