package org.maachang.jni.io ;


/**
 * MmapBuffer.
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public interface MmapBuffer extends NativeBuffer {
    /** MMAPモード : 読み込み. **/
    public static final int OPT_READ = NativeIODefine.MMAP_OPT_READ ;
    /** MMAPモード : 読み込み+書き込み. **/
    public static final int OPT_WRITE = NativeIODefine.MMAP_OPT_WRITE ;
    
    /**
     * mmap再割り当て.
     * @param offset mmap開始位置を設定します.
     * @param length mmap設定長を設定します.
     * @exception Exception 例外.
     */
    public void reCreate( long offset,int length ) throws Exception ;
    
    /**
     * 指定長のmmap領域を強制書き込み.
     * @exception Exception 例外.
     */
    public void flush() throws Exception ;
    
    /**
     * mmap対象元のファイルオブジェクトを取得.
     * @return io 対象のファイルオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public NativeRandomIO getFileObject() throws Exception ;
    
    /**
     * mmap対象元のファイルが閉じているかチェック.
     * @return boolean [true]の場合、ファイルは閉じています.
     */
    public boolean isFileClose() ;
    
    /**
     * mmap Read/Writeモードを取得.
     * @return int mmap Read/Writeモードが返されます.
     */
    public int getOption() ;
    
    /**
     * オフセット値+長さを取得.
     * @return long オフセット値+長さのアドレスが返されます.
     */
    public long getOffsetLength() ;
}

