/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.impl.SqlSearchElement;
import org.maachang.mimdb.core.util.NumberList;

public final class SqlAnalyzer {
    private static final int LIST_LENGTH = 32;

    private SqlAnalyzer() {
    }

    public static final void analysis(MimdbStatement out, String sql) throws Exception {
        int s;
        int p = SqlAnalyzer.lastSQL(sql);
        if (p != -1) {
            sql = sql.substring(0, p);
        }
        out.clear();
        sql = sql.trim();
        String low = sql.toLowerCase();
        int sqlLen = low.length();
        int off = 0;
        if (low.startsWith("select ")) {
            off = SqlAnalyzer._noSpace(low, 6, sqlLen);
        }
        NumberList list = new NumberList(32);
        while ((s = SqlAnalyzer._noSpaceString(low, off, sqlLen)) != -1 && !SqlAnalyzer.eq(low, "from", s)) {
            off = SqlAnalyzer._noSpace(low, off + SqlAnalyzer.length(s), sqlLen);
            if (SqlAnalyzer.eq(low, ",", s)) continue;
            SqlAnalyzer._columnAnalysis(low, list, s);
        }
        if (!SqlAnalyzer.eq(low, "from", s)) {
            throw new MimdbException("SQL\u6587\u306e\u30c6\u30fc\u30d6\u30eb\u540d\u6307\u5b9a\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093:" + sql);
        }
        if (list.size() == 0) {
            throw new MimdbException("SQL\u6587\u3067\u306e\u53d6\u5f97\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093:" + sql);
        }
        SqlAnalyzer._viewColumnBySetStatement(out, list, sql, low);
        list.clear();
        off = SqlAnalyzer._noSpace(low, off + 4, sqlLen);
        s = SqlAnalyzer._noSpaceString(low, off, sqlLen);
        if (s == -1 || SqlAnalyzer.eq(low, "where", s) || SqlAnalyzer.eq(low, "order", s)) {
            throw new MimdbException("SQL\u6587\u306b\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u307e\u305b\u3093:" + sql);
        }
        out.setTable(SqlAnalyzer.substring(low, s));
        while ((off = s == -1 ? SqlAnalyzer._noSpace(low, off, sqlLen) : SqlAnalyzer._noSpace(low, off + SqlAnalyzer.length(s), sqlLen)) != -1) {
            s = SqlAnalyzer._noSpaceString(low, off, sqlLen);
            if (SqlAnalyzer.eq(low, "where", s)) {
                off = SqlAnalyzer._whereAnalysis(list, off + SqlAnalyzer.length(s), sql, low);
                SqlAnalyzer._whereBySetStatement(out, list, sql, low);
                list.clear();
                s = -1;
                continue;
            }
            if (SqlAnalyzer.eq(low, "order", s)) {
                if ((off = SqlAnalyzer._noSpace(low, off + SqlAnalyzer.length(s), sqlLen)) == -1) {
                    throw new MimdbException("order by\u6761\u4ef6\u304c\u4e0d\u660e\u3067\u3059:" + sql);
                }
                s = SqlAnalyzer._noSpaceString(low, off, sqlLen);
                if (SqlAnalyzer.eq(low, "by", s)) {
                    off = SqlAnalyzer._orderByAnalysis(list, off + SqlAnalyzer.length(s), sql, low);
                    SqlAnalyzer._orderBySetStatement(out, list, sql, low);
                    list.clear();
                    s = -1;
                    continue;
                }
                throw new MimdbException("order by\u6761\u4ef6\u304c\u4e0d\u660e\u3067\u3059:" + sql);
            }
            if (!SqlAnalyzer.eq(low, "offset", s) && !SqlAnalyzer.eq(low, "limit", s)) continue;
            off = SqlAnalyzer.offLimit(out, off, s, sql, low, sqlLen);
            s = -1;
        }
        return;
    }

    private static final int lastSQL(String sql) {
        int b = 0;
        int cote = -1;
        int i = sql.length() - 1;
        while (i >= 0) {
            block5: {
                int c;
                block4: {
                    block3: {
                        c = sql.charAt(i);
                        if (cote == -1) break block3;
                        if (c != cote || b == 92) break block4;
                        cote = -1;
                        break block5;
                    }
                    if (c == 59) {
                        return i;
                    }
                    if (c == 39 || c == 34) {
                        cote = c;
                    }
                }
                b = c;
            }
            --i;
        }
        return -1;
    }

    private static final boolean eq(String sql, String chk, int mg) {
        int o = 0;
        int p = mg & 0xFFFF;
        int len = (mg & 0xFFFF0000) >> 16;
        while (p < len) {
            if (sql.charAt(p++) == chk.charAt(o++)) continue;
            return false;
        }
        return chk.length() == o;
    }

    private static final int startPos(int mg) {
        return mg & 0xFFFF;
    }

    private static final int endPos(int mg) {
        return mg >> 16;
    }

    private static final int length(int mg) {
        return (mg >> 16) - (mg & 0xFFFF);
    }

    private static final int marge(int s, int e) {
        return s | e << 16;
    }

    private static final String substring(String src, int mg) {
        return src.substring(SqlAnalyzer.startPos(mg), SqlAnalyzer.endPos(mg));
    }

    private static final int _noSpace(String sql, int pos, int sqlLen) {
        if (pos < sqlLen && sql.charAt(pos) == ' ') {
            while (++pos < sqlLen && sql.charAt(pos) == ' ') {
            }
        }
        if (pos >= sqlLen) {
            return -1;
        }
        return pos;
    }

    private static final int _noSpaceString(String sql, int pos, int sqlLen) {
        if (pos >= sqlLen || sql.charAt(pos) == ' ') {
            return -1;
        }
        int p = pos;
        while (++p < sqlLen && sql.charAt(p) != ' ') {
        }
        if (p > sqlLen) {
            return -1;
        }
        return SqlAnalyzer.marge(pos, p);
    }

    private static final void _columnAnalysis(String src, NumberList out, int pos) {
        int st = SqlAnalyzer.startPos(pos);
        int ed = SqlAnalyzer.endPos(pos);
        int s = -1;
        int i = st;
        while (i < ed) {
            char c = src.charAt(i);
            if (c == ',') {
                if (s != -1) {
                    out.add(SqlAnalyzer.marge(s, i));
                    s = -1;
                }
            } else if (c == '(' || c == ')') {
                if (s != -1) {
                    out.add(SqlAnalyzer.marge(s, i));
                    s = -1;
                }
                out.add(SqlAnalyzer.marge(i, i + 1));
            } else if (s == -1) {
                s = i;
            }
            ++i;
        }
        if (s != -1) {
            out.add(SqlAnalyzer.marge(s, ed));
        }
    }

    private static final int _whereAnalysis(NumberList out, int off, String sql, String low) throws Exception {
        int cote = -1;
        int par = 0;
        int len = low.lastIndexOf(" order ");
        if (len == -1) {
            len = low.length();
        }
        int s = -1;
        int i = off;
        while (i < len) {
            char c = low.charAt(i);
            if (c == '\'' || c == '\"') {
                if (cote == -1) {
                    cote = c == '\'' ? 0 : 1;
                    if (s != -1) {
                        out.add(SqlAnalyzer.marge(s, i));
                        s = -1;
                    }
                    s = i + 1;
                } else if (cote == 0 && c == '\'' || cote == 1 && c == '\"') {
                    cote = -1;
                    if (s != -1) {
                        out.add(SqlAnalyzer.marge(s, i));
                        s = -1;
                    }
                }
            } else if (cote == -1) {
                if (c == ' ' || c == ';' || c == ',') {
                    if (s != -1) {
                        out.add(SqlAnalyzer.marge(s, i));
                        s = -1;
                    }
                } else if (c == '<' || c == '>' || c == '=' || c == '!' || c == '(' || c == ')') {
                    if (s != -1) {
                        out.add(SqlAnalyzer.marge(s, i));
                        s = -1;
                    }
                    out.add(SqlAnalyzer.marge(i, i + 1));
                    if (c == '(') {
                        ++par;
                    } else if (c == ')') {
                        --par;
                    }
                } else if (s == -1) {
                    s = i;
                }
            }
            ++i;
        }
        if (cote != -1 || par != 0) {
            if (cote != -1) {
                throw new MimdbException("\u6587\u5b57\u6307\u5b9a\u306e\u9589\u3058\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093:" + sql);
            }
            throw new MimdbException("\u62ec\u5f27\u306e\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059:" + sql);
        }
        if (s != -1) {
            out.add(SqlAnalyzer.marge(s, len));
        }
        return len;
    }

    private static final int _orderByAnalysis(NumberList out, int off, String sql, String low) {
        int len = low.length();
        int s = -1;
        int i = off;
        while (i < len) {
            char c = low.charAt(i);
            if (c == ' ' || c == ',' || c == ';') {
                if (s != -1) {
                    out.add(SqlAnalyzer.marge(s, i));
                    s = -1;
                }
            } else if (s == -1) {
                s = i;
            }
            ++i;
        }
        if (s != -1) {
            out.add(SqlAnalyzer.marge(s, len));
        }
        return len;
    }

    private static final void _viewColumnBySetStatement(MimdbStatement out, NumberList in, String sql, String low) throws Exception {
        int len = in.size();
        if (len == 1 && SqlAnalyzer.eq(low, "*", in.get(0))) {
            out.setViewColumn("*");
        } else if (len >= 4 && SqlAnalyzer.eq(low, "count", in.get(0)) && SqlAnalyzer.eq(low, "(", in.get(1)) && SqlAnalyzer.eq(low, ")", in.get(3))) {
            out.setViewCount();
        } else {
            int i = 0;
            while (i < len) {
                int s = in.get(i);
                if (SqlAnalyzer.length(s) == 1 && (SqlAnalyzer.eq(low, "(", s) || SqlAnalyzer.eq(low, ")", s) || SqlAnalyzer.eq(low, "*", s))) {
                    throw new MimdbException("\u4e0d\u6b63\u306aSQL\u8868\u793a\u6761\u4ef6[" + SqlAnalyzer.substring(sql, s) + "]:" + sql);
                }
                out.setViewColumn(SqlAnalyzer.substring(low, s));
                ++i;
            }
        }
    }

    private static final void _whereBySetStatement(MimdbStatement out, NumberList in, String sql, String low) throws Exception {
        int len = in.size();
        int i = 0;
        while (i < len) {
            int s = in.get(i);
            if (SqlAnalyzer.eq(low, "and", s) || SqlAnalyzer.eq(low, "&", s)) {
                out.addWhere(new SqlSearchElement(20));
            } else if (SqlAnalyzer.eq(low, "or", s) || SqlAnalyzer.eq(low, "|", s)) {
                out.addWhere(new SqlSearchElement(21));
            } else if (SqlAnalyzer.eq(low, "(", s)) {
                out.addWhere(new SqlSearchElement(10));
            } else if (SqlAnalyzer.eq(low, ")", s)) {
                out.addWhere(new SqlSearchElement(11));
            } else {
                int type;
                String column = SqlAnalyzer.substring(low, s);
                if (++i >= len) {
                    throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                }
                s = in.get(i);
                char c = low.charAt(SqlAnalyzer.startPos(s));
                if (c == '=') {
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[=]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        out.addWhere(new SqlSearchElement(column, 1));
                    } else {
                        out.addWhere(new SqlSearchElement(column, 1, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else if (c == '!') {
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[!]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    if (!SqlAnalyzer.eq(low, "=", in.get(i))) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[!]\u306f xxx != 0 \u3067\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059:" + sql);
                    }
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[!]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        out.addWhere(new SqlSearchElement(column, 2));
                    } else {
                        out.addWhere(new SqlSearchElement(column, 2, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else if (c == '>') {
                    type = 3;
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[>]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    if (SqlAnalyzer.eq(low, "=", in.get(i))) {
                        if (++i >= len) {
                            throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[>=]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                        }
                        type = 4;
                    }
                    if (SqlAnalyzer.eq(low, "?", s = in.get(i))) {
                        out.addWhere(new SqlSearchElement(column, type));
                    } else {
                        out.addWhere(new SqlSearchElement(column, type, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else if (c == '<') {
                    type = 5;
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[<]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    if (SqlAnalyzer.eq(low, "=", in.get(i))) {
                        if (++i >= len) {
                            throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[<=]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                        }
                        type = 6;
                    } else if (SqlAnalyzer.eq(low, ">", in.get(i))) {
                        if (++i >= len) {
                            throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[<>]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                        }
                        type = 2;
                    }
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        out.addWhere(new SqlSearchElement(column, type));
                    } else {
                        out.addWhere(new SqlSearchElement(column, type, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else if (SqlAnalyzer.eq(low, "in", s) || SqlAnalyzer.eq(low, "between", s)) {
                    String vtype;
                    int wtype;
                    if (SqlAnalyzer.eq(low, "in", s)) {
                        wtype = 7;
                        vtype = "IN";
                    } else {
                        wtype = 9;
                        vtype = "BETWEEN";
                    }
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        out.addWhere(new SqlSearchElement(column, wtype));
                    } else {
                        if (!SqlAnalyzer.eq(low, "(", s)) {
                            throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u3001xxx " + vtype + " ( ... ) \u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059:" + sql);
                        }
                        if (++i >= len) {
                            throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                        }
                        if (SqlAnalyzer.eq(low, "?", in.get(i))) {
                            if (++i >= len) {
                                throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                            }
                            if (!SqlAnalyzer.eq(low, ")", in.get(i))) {
                                throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u3001xxx " + vtype + " (?) \u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059:" + sql);
                            }
                            out.addWhere(new SqlSearchElement(column, wtype));
                        } else {
                            s = in.get(i);
                            if (SqlAnalyzer.eq(low, ")", s)) {
                                throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u3001xxx " + vtype + " ( ... ) \u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059:" + sql);
                            }
                            ArrayList<Object> list = new ArrayList<Object>(16);
                            do {
                                list.add(SqlAnalyzer._null(SqlAnalyzer.substring(sql, s)));
                                if (++i < len) continue;
                                throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[" + vtype + "]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                            } while (!SqlAnalyzer.eq(low, ")", s = in.get(i)));
                            out.addWhere(new SqlSearchElement(column, wtype, list));
                            list = null;
                        }
                    }
                } else if (SqlAnalyzer.eq(low, "like", s)) {
                    if (++i >= len) {
                        throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6[LIKE]\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                    }
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        out.addWhere(new SqlSearchElement(column, 8));
                    } else {
                        out.addWhere(new SqlSearchElement(column, 8, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else if ("offset".equals(column) || "limit".equals(column)) {
                    s = in.get(i);
                    if (SqlAnalyzer.eq(low, "?", s)) {
                        if ("offset".equals(column)) {
                            out.addWhere(new SqlSearchElement("offset", 30));
                        } else {
                            out.addWhere(new SqlSearchElement("limit", 30));
                        }
                    } else if ("offset".equals(column)) {
                        out.addWhere(new SqlSearchElement("offset", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    } else {
                        out.addWhere(new SqlSearchElement("limit", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                    }
                } else {
                    throw new MimdbException("where\u5224\u5225[" + column + "]\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059:" + sql);
                }
            }
            ++i;
        }
    }

    private static final void _orderBySetStatement(MimdbStatement out, NumberList in, String sql, String low) throws Exception {
        int s;
        int len = in.size();
        if (len == 0) {
            throw new MimdbException("order\u5b9a\u7fa9\u306b\u304a\u3044\u3066\u3001\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093:" + sql);
        }
        int last = -1;
        int i = 0;
        while (i < len) {
            s = in.get(i);
            if (SqlAnalyzer.eq(low, "offset", s) || SqlAnalyzer.eq(low, "limit", s)) {
                boolean offsetFlag = SqlAnalyzer.eq(low, "offset", s);
                s = in.get(i + 1);
                if (SqlAnalyzer.eq(low, "?", s)) {
                    if (offsetFlag) {
                        out.addWhere(new SqlSearchElement("offset", 30));
                    } else {
                        out.addWhere(new SqlSearchElement("limit", 30));
                    }
                } else if (offsetFlag) {
                    out.addWhere(new SqlSearchElement("offset", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                } else {
                    out.addWhere(new SqlSearchElement("limit", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
                }
                if (last == -1) {
                    last = i;
                }
            }
            ++i;
        }
        if (last != -1) {
            len = last;
        }
        boolean desc = false;
        int i2 = len - 1;
        while (i2 >= 0) {
            s = in.get(i2);
            if (SqlAnalyzer.eq(low, "desc", s)) {
                desc = true;
            } else if (SqlAnalyzer.eq(low, "asc", s)) {
                desc = false;
            } else {
                out.addSortColumn(SqlAnalyzer.substring(low, s), desc);
            }
            --i2;
        }
    }

    private static final int offLimit(MimdbStatement out, int off, int s, String sql, String low, int sqlLen) throws Exception {
        int off_limit = SqlAnalyzer.eq(low, "offset", s) ? 1 : 2;
        if ((off = SqlAnalyzer._noSpace(low, off + SqlAnalyzer.length(s), sqlLen)) == -1) {
            if (off_limit == 1) {
                throw new MimdbException("offset\u6761\u4ef6\u304c\u4e0d\u660e\u3067\u3059:" + sql);
            }
            throw new MimdbException("limit\u6761\u4ef6\u304c\u4e0d\u660e\u3067\u3059:" + sql);
        }
        s = SqlAnalyzer._noSpaceString(low, off, sqlLen);
        if (SqlAnalyzer.eq(low, "?", s)) {
            if (off_limit == 1) {
                out.addWhere(new SqlSearchElement("offset", 30));
            } else {
                out.addWhere(new SqlSearchElement("limit", 30));
            }
        } else if (off_limit == 1) {
            out.addWhere(new SqlSearchElement("offset", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
        } else {
            out.addWhere(new SqlSearchElement("limit", 30, SqlAnalyzer._null(SqlAnalyzer.substring(sql, s))));
        }
        return off + SqlAnalyzer.length(s);
    }

    private static final Object _null(String s) {
        return s == null || "null".equals(s.toLowerCase()) ? null : s;
    }
}

