package org.maachang.mimdb.core.impl ;

import java.util.Arrays;

/**
 * 数値一致確認オブジェクト.
 * 
 * @version 2013/10/27
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class EqualsNoList {
    private final int[] list ;
    private final int[] src ;
    
    /** コンストラクタ. **/
    private EqualsNoList() {
    	list = null ;
    	src = null ;
    }
    
    /**
     * コンストラクタ.
     * @param n 対象の配列を設定します.
     */
    public EqualsNoList( int[] n ) {
        int len = n.length ;
        list = new int[ len ] ;
        System.arraycopy( n,0,list,0,len ) ;
        Arrays.sort( list ) ;
        src = n ;
    }
    
    /**
     * 指定条件が一致するかチェック.
     * @param n 指定条件を設定します.
     * @return boolean [true]の場合は、一致しています.
     */
    public boolean equals( int n ) {
        return ( MimdbUtils.searchInt( list,n ) != -1 ) ;
    }
    
    /**
     * 元情報の取得.
     * @param no 対象項番を設定します.
     * @return int 元情報が返却されます.
     */
    public int src( int no ) {
        return src[ no ] ;
    }
    
    /**
     * 元情報配列の取得.
     * @return int[] 元情報配列が返却されます.
     */
    public int[] arrays() {
        return src ;
    }
    
    /**
     * サイズの取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return src.length ;
    }
    
}
