package org.maachang.mimdb.core.impl;

/**
 * Likeパーサー.
 * 
 * @version 2013/10/13
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface LikeParser {
    
    /** 先頭位置を示す **/
    public static final int POS_FIRST = 0 ;
    
    /** 終端を示す **/
    public static final int POS_LAST = -9 ;
    
    /** 文字数無限 **/
    public static final int POS_BETWEEN = -1 ;
    
    /**
     * Like文の取得.
     * @return String Like文が返却されます.
     */
    public String getSrc() ;
    
    /**
     * パーサーを取得.
     * @param no 対象の項番を設定します.
     * @return Object 対象項番のパーサー情報が返却されます.
     */
    public Object get( int no ) ;
    
    /**
     * 情報長の取得.
     * @return int 情報長が返却されます.
     */
    public int size() ;
    
    /**
     * 全パーサー情報を取得.
     * @return Object[] 全パーサー情報が返却されます.
     */
    public Object[] getAll() ;
    
    /**
     * パーサー内容を入れ替え.
     * @param o 入れ替え対象のオブジェクトを設定します.
     */
    public void set( Object[] o ) ;
}
