package org.maachang.mimdb.jdbc ;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbStatement;

/**
 * Mimdb-JDBC Connection.
 * 
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class MimdbJdbcConnection implements java.sql.Connection {
    protected MimdbStatement statement = null ;
    protected Map<String,MimdbPreparedStatement> pst_cache = new WeakHashMap<String,MimdbPreparedStatement>() ;
    
    public MimdbJdbcConnection() {
    }
    
    public void close() throws SQLException {
        if( statement != null ) {
            statement.clear() ;
            statement = null ;
        }
        pst_cache.clear() ;
    }
    
    public void commit() throws SQLException {
    }
    
    public void rollback() throws SQLException {
    }
    
    public Statement createStatement() throws SQLException {
        return new MimdbJdbcStatement( this ) ;
    }
    
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        MimdbPreparedStatement pst = pst_cache.get( sql ) ;
        if( pst == null ) {
            MimdbStatement stmt ;
            pst = new MimdbPreparedStatement() ;
            try {
                stmt = MimdbStatement.createStatement( sql ) ;
                stmt.compile( pst ) ;
                pst_cache.put( sql,pst ) ;
            } catch( Exception e ) {
                throw new SQLException( e ) ;
            }
            statement = stmt ;
        }
        return new MimdbJdbcPreparedStatement( this,pst ) ;
    }
    
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public String nativeSQL(String sql) throws SQLException {
        return null ;
    }
    
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }
    
    public boolean getAutoCommit() throws SQLException {
        return true ;
    }
    
    public boolean isClosed() throws SQLException {
        return statement == null ;
    }
    
    // ======================================================================
    // Advanced features:
    
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public void setReadOnly(boolean readOnly) throws SQLException {
    }
    
    public boolean isReadOnly() throws SQLException {
        return true ;
    }
    
    public void setCatalog(String catalog) throws SQLException {
    }
    
    public String getCatalog() throws SQLException {
        return null ;
    }
    
    public void setTransactionIsolation(int level) throws SQLException {
    }
    
    public int getTransactionIsolation() throws SQLException {
        return Connection.TRANSACTION_NONE  ;
    }
    
    public SQLWarning getWarnings() throws SQLException {
        return null ;
    }
    
    public void clearWarnings() throws SQLException {
    }
    
    // --------------------------JDBC 2.0-----------------------------
    
    public Statement createStatement(int resultSetType, int resultSetConcurrency)
        throws SQLException {
        return createStatement() ;
    }
    
    public PreparedStatement prepareStatement(String sql, int resultSetType,
        int resultSetConcurrency) throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public CallableStatement prepareCall(String sql, int resultSetType,
        int resultSetConcurrency) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public java.util.Map<String, Class<?>> getTypeMap() throws SQLException {
        return null ;
    }
    
    public void setTypeMap(java.util.Map<String, Class<?>> map)
        throws SQLException {
    }
    
    // --------------------------JDBC 3.0-----------------------------
    
    public void setHoldability(int holdability) throws SQLException {
    }
    
    public int getHoldability() throws SQLException {
        return ResultSet.HOLD_CURSORS_OVER_COMMIT ;
    }
    
    public Savepoint setSavepoint() throws SQLException {
        return null ;
    }
    
    public Savepoint setSavepoint(String name) throws SQLException {
        return null ;
    }
    
    public void rollback(Savepoint savepoint) throws SQLException {
    }
    
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }
    
    public Statement createStatement(int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        return createStatement() ;
    }
    
    public PreparedStatement prepareStatement(String sql, int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public CallableStatement prepareCall(String sql, int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, int columnIndexes[])
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, String columnNames[])
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public Clob createClob() throws SQLException {
        return null ;
    }
    
    public Blob createBlob() throws SQLException {
        return null ;
    }
    
    public NClob createNClob() throws SQLException {
        return null ;
    }
    
    public SQLXML createSQLXML() throws SQLException {
        return null ;
    }
    
    public boolean isValid(int timeout) throws SQLException {
        return true ;
    }
    
    public void setClientInfo(String name, String value)
        throws SQLClientInfoException {
    }
    
    public void setClientInfo(Properties properties)
        throws SQLClientInfoException {
    }
    
    public String getClientInfo(String name) throws SQLException {
        return null ;
    }
    
    public Properties getClientInfo() throws SQLException {
        return null ;
    }
    
    public Array createArrayOf(String typeName, Object[] elements)
        throws SQLException {
        return null ;
    }
    
    public Struct createStruct(String typeName, Object[] attributes)
        throws SQLException {
        return null ;
    }
    
    // Wrapper.java
    public <T> T unwrap(java.lang.Class<T> iface) throws java.sql.SQLException {
        return null ;
    }
    
    public boolean isWrapperFor(java.lang.Class<?> iface)
        throws java.sql.SQLException {
        return false ;
    }
    
    public void setSchema(String schema) throws SQLException {
    }
    
    public String getSchema() throws SQLException {
        return null ;
    }
    
    public void abort(Executor executor) throws SQLException {
    }
    
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }
    
    public int getNetworkTimeout() throws SQLException {
        return 0 ;
    }
}
