package org.maachang.mimdb.jdbc ;

import java.sql.SQLException;

import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbTableManager;

/**
 * Mimdb-JDBC プリコンパイル済み
 * パラメータメタデータ.
 * 
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class MimdbJdbcParameterMetaData implements java.sql.ParameterMetaData {
    protected MimdbPreparedStatement pstmt ;
    
    protected MimdbJdbcParameterMetaData( MimdbPreparedStatement p ) {
        pstmt = p ;
    }
    
    public String getParameterClassName(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getColumnClassName(
            pstmt.paramNoByColumnType( param-1 ) ) ;
    }
    public int getParameterCount() throws SQLException {
        return pstmt.paramsLength() ;
    }
    public int getParameterMode(int param) throws SQLException {
        return parameterModeUnknown ;
    }
    public int getParameterType(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getColumnType(
            pstmt.paramNoByColumnType( param-1 ) ) ;
    }
    public String getParameterTypeName(int param) throws SQLException {
        return getParameterClassName( param ) ;
    }
    public int getPrecision(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getPrecision(
            pstmt.paramNoByColumnType( param-1 ) ) ;
    }
    public int getScale(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getScale(
            pstmt.paramNoByColumnType( param-1 ) ) ;
    }
    public int isNullable(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._isNullable(
            param,MimdbTableManager.getInstance().get( pstmt.getName() ) ) ;
    }
    public boolean isSigned(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._isSigned(
            pstmt.paramNoByColumnType( param-1 ) ) ;
    }
    
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false ;
    }
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null ;
    }
}
