package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.seasar.dao.BeanMetaData;


/**
 * @author higa
 *
 */
public class BeanMetaDataFactory {

	private static Map beanMetaDataCache_ = new HashMap();

	private BeanMetaDataFactory() {
	}

	public static BeanMetaData getBeanMetaData(Class beanClass) {
		BeanMetaData bmd = (BeanMetaData) beanMetaDataCache_.get(beanClass.getName());
		if (bmd != null) {
			return bmd;
		}
		synchronized (BeanMetaDataFactory.class) {
			bmd = (BeanMetaData) beanMetaDataCache_.get(beanClass.getName());
			if (bmd != null) {
				return bmd;
			}
			bmd = new BeanMetaDataImpl(beanClass);
			beanMetaDataCache_.put(beanClass.getName(), bmd);
		}
		return bmd;
	}
}
