package org.seasar.dao.impl;

import java.util.List;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.impl.DataTableImpl;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyDesc;

public class BeanReader implements DataReader {

	private DataTable table_;

	private BeanMetaData beanMetaData_;

	public BeanReader(Class beanClass, Object source) {
		beanMetaData_ = BeanMetaDataFactory.getBeanMetaData(beanClass);
		table_ = new DataTableImpl(beanMetaData_.getTableName());
		setupColumns();
		setupRows(source);
	}

	private void setupColumns() {
		for (int i = 0; i < beanMetaData_.getPropertyTypeSize(); ++i) {
			PropertyType pt = beanMetaData_.getPropertyType(i);
			Class propertyType = pt.getPropertyDesc().getPropertyType();
			table_.addColumn(pt.getColumnName(), ColumnTypes
					.getColumnType(propertyType));
		}
		for (int i = 0; i < beanMetaData_.getRelationPropertyTypeSize(); ++i) {
			RelationPropertyType rpt = beanMetaData_.getRelationPropertyType(i);
			for (int j = 0; j < rpt.getBeanMetaData().getPropertyTypeSize(); j++) {
				PropertyType pt = rpt.getBeanMetaData().getPropertyType(j);
				if (!rpt.isYourKey(pt.getColumnName())) {
					String columnName = pt.getColumnName() + "_"
							+ rpt.getRelationNo();
					Class propertyType = pt.getPropertyDesc().getPropertyType();
					table_.addColumn(columnName, ColumnTypes
							.getColumnType(propertyType));
				}
			}
		}
	}

	private void setupRows(Object source) {
		if (source instanceof List) {
			List list = (List) source;
			for (int i = 0; i < list.size(); i++) {
				setupRow(list.get(i));
			}
		} else {
			setupRow(source);
		}
	}

	private void setupRow(Object source) {
		DataRow row = table_.addRow();
		for (int i = 0; i < beanMetaData_.getPropertyTypeSize(); ++i) {
			PropertyType pt = beanMetaData_.getPropertyType(i);
			PropertyDesc pd = pt.getPropertyDesc(); 
			Object value = pd.getValue(source);
			ColumnType ct = ColumnTypes.getColumnType(pd.getPropertyType());
			row.setValue(pt.getColumnName(), ct.convert(value, null));
		}
		for (int i = 0; i < beanMetaData_.getRelationPropertyTypeSize(); ++i) {
			RelationPropertyType rpt = beanMetaData_.getRelationPropertyType(i);
			Object relationBean = rpt.getPropertyDesc().getValue(source);
			for (int j = 0; j < rpt.getBeanMetaData().getPropertyTypeSize(); j++) {
				PropertyType pt = rpt.getBeanMetaData().getPropertyType(j);
				if (!rpt.isYourKey(pt.getColumnName())) {
					String columnName = pt.getColumnName() + "_"
							+ rpt.getRelationNo();
					PropertyDesc pd = pt.getPropertyDesc();
					Object value = pd.getValue(relationBean);
					ColumnType ct = ColumnTypes.getColumnType(pd.getPropertyType());
					row.setValue(columnName, ct.convert(value, null));
				}
			}
		}
	}

	public DataSet read() {
		DataSet dataSet = new DataSetImpl();
		dataSet.addTable(table_);
		return dataSet;
	}

}