package org.seasar.dao.unit;

import java.util.List;

import junit.framework.Assert;

import org.seasar.dao.impl.BeanReader;
import org.seasar.extension.dataset.DataSet;

public final class BeanAssert {

	private BeanAssert() {
	}

	public static void assertEquals(String message, DataSet expected,
			Object actual) {

		Assert.assertNotNull(expected);
		Assert.assertNotNull(actual);

		Class beanClass = null;
		if (actual instanceof List) {
			List actualList = (List) actual;
			Assert.assertFalse(actualList.isEmpty());
			beanClass = actualList.get(0).getClass();
		} else {
			beanClass = actual.getClass();
		}

		BeanReader reader = new BeanReader(beanClass, actual);
		Assert.assertEquals(message, expected, reader.read());
	}

	public static void assertEquals(DataSet expected, Object actual) {
		assertEquals(null, expected, actual);
	}

}