package examples.hibernate.client;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

import examples.hibernate.entity.Department;
import examples.hibernate.service.DepartmentService;

public class DepartmentClient {

	private static final String PATH =
		"examples/hibernate/client/Department.dicon";

	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);
		container.init();
		try {
			DepartmentService service =
				(DepartmentService) container.getComponent(DepartmentService.class);
			Department dept = service.getDepartment((short) 20);
			
			System.out.println(dept.getDname());
			
//			x[hݒ肵ĂꍇA
//			̗lȋLq́ASessionN[YĂ̂ŃG[B
//			System.out.println(dept.getEmployeeList() );

		} catch(Throwable t) {
			System.out.println("exeption:" + t);
		} finally {
			container.destroy();
		}

	}
}
