package examples.hibernate.dao;

import java.util.List;

import net.sf.hibernate.Hibernate;

import org.seasar.hibernate.S2SessionFactory;

import examples.hibernate.entity.Department;

public class DepartmentDaoImpl implements DepartmentDao {

	private static final String HQL = "from Department where deptno = ?";
	private S2SessionFactory sessionFactory_;

	public DepartmentDaoImpl(S2SessionFactory sessionFactory) {
		sessionFactory_ = sessionFactory;
	}

	public Department getDepartment(short deptno) {
		List result = sessionFactory_.getSession().find(
			HQL, new Short(deptno), Hibernate.SHORT);
		if (result.size() > 0) {
			return (Department) result.get(0);
		} else {
			return null;
		}
	}

	public void save(Department department) {
		sessionFactory_.getSession().save(department);
		
	}
}
