package org.seasar.framework.exception;

import org.seasar.framework.message.MessageFormatter;

/**
 * @author higa
 *
 * Seasar̎sÕx[XƂȂNXłB<br />
 * bZ[WR[hɂėOڍׂɓł܂B<br />
 * @see org.seasar.framework.message.MessageFormatter
 */
public class SRuntimeException extends RuntimeException {

	private String messageCode_;
	private Object[] args_;
	private String message_;

	public SRuntimeException(String messageCode) {
		this(messageCode, null, null);
	}

	public SRuntimeException(String messageCode, Object[] args) {
		this(messageCode, args, null);
	}

	public SRuntimeException(
		String messageCode,
		Object[] args,
		Throwable cause) {

		super(cause);
		messageCode_ = messageCode;
		args_ = args;
		message_ = MessageFormatter.getMessage(messageCode_, args_);
	}

	public final String getMessageCode() {
		return messageCode_;
	}

	public final Object[] getArgs() {
		return args_;
	}

	public final String getMessage() {
		return message_;
	}
	
	protected void setMessage(String message) {
		message_ = message;
	}
}