/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.parser.SqlParserImpl;

public abstract class AbstractDynamicCommand
extends AbstractSqlCommand {
    private Node rootNode_;
    private String[] argNames_ = new String[0];

    public AbstractDynamicCommand(DataSource dataSource) {
        super(dataSource);
    }

    public void setSql(String sql) {
        super.setSql(sql);
        this.rootNode_ = new SqlParserImpl(sql).parse();
    }

    public String[] getArgNames() {
        return this.argNames_;
    }

    public void setArgNames(String[] argNames) {
        this.argNames_ = argNames;
    }

    protected CommandContext apply(Object[] args) {
        CommandContext ctx = this.createCommandContext(args);
        this.rootNode_.accept(ctx);
        return ctx;
    }

    protected CommandContext createCommandContext(Object[] args) {
        CommandContextImpl ctx = new CommandContextImpl();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i < this.argNames_.length) {
                    ctx.addArg(this.argNames_[i], args[i]);
                } else {
                    ctx.addArg("$" + (i + 1), args[i]);
                }
                ++i;
            }
        }
        return ctx;
    }
}

