package org.seasar.dao.node;

import org.seasar.dao.CommandContext;
import org.seasar.framework.util.OgnlUtil;

/**
 * @author higa
 *
 */
public class BindVariableNode extends AbstractNode {

	private String expression_;
	private Object parsedExpression_;
	
	public BindVariableNode(String expression) {
		expression_ = expression;
		parsedExpression_ = OgnlUtil.parseExpression(expression);
	}

	public String getExpression() {
		return expression_;
	}

	/**
	 * @see org.seasar.dao.Node#accept(org.seasar.dao.QueryContext)
	 */
	public void accept(CommandContext ctx) {
		ctx.addSql("?", OgnlUtil.getValue(parsedExpression_, ctx));
	}

}
