package test.org.seasar.dao.impl;

import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.extension.unit.S2TestCase;

public class InsertAutoStaticCommandTest extends S2TestCase {

	public InsertAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		InsertAutoStaticCommand cmd = new InsertAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Employee.class,
						getDatabaseMetaData()));
		Employee emp = new Employee();
		emp.setEmpno(99);
		emp.setEname("hoge");
		Integer count = (Integer) cmd.execute(new Object[] { emp });
		assertEquals("1", new Integer(1), count);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(InsertAutoStaticCommandTest.class);
	}

}